/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import io.prestosql.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateAggregationsWithDefaultValues
extends BasePlanTest {
    private Metadata metadata;
    private PlanBuilder builder;
    private Symbol symbol;
    private TableScanNode tableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata);
        CatalogName catalogName = this.getCurrentConnectorId();
        TableHandle nationTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)new TpchTableHandle("nation", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.symbol = new Symbol("nationkey");
        this.tableScanNode = this.builder.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)this.symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.symbol, (Object)nationkeyColumnHandle));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by remote hash exchange")
    public void testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testSingleThreadFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.values(new Symbol[0])))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testGloballyDistributedFinalAggregationSeparatedFromPartialAggregationByRemoteHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.REMOTE).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test
    public void testSingleNodeFinalAggregationSeparatedFromPartialAggregationByLocalHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testWithPartialAggregationBelowJoin() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)))), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testWithPartialAggregationBelowJoinWithoutSeparatingExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    private void validatePlan(PlanNode root, boolean forceSingleNode) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateAggregationsWithDefaultValues(forceSingleNode).validate(root, session, this.metadata, new TypeAnalyzer(new SqlParser(), this.metadata), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }
}

