/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.airlift.testing.Assertions;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.assertions.PlanAssert;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this.runner = new LocalQueryRunner(session);
    }

    public void assertFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        block2: {
            try {
                this.runner.execute(this.runner.getDefaultSession(), sql).toTestTypes();
                Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
            catch (RuntimeException exception) {
                if (Strings.nullToEmpty((String)exception.getMessage()).matches(expectedMessageRegExp)) break block2;
                Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", exception.getMessage(), expectedMessageRegExp, sql), (Throwable)exception);
            }
        }
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        this.assertQuery(actual, expected);
        Plan plan = this.runner.createPlan(this.runner.getDefaultSession(), actual, WarningCollector.NOOP);
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getMetadata(), this.runner.getStatsCalculator(), plan, pattern);
        planValidator.accept(plan);
    }

    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQuery(actual, expected, false);
    }

    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(actual);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.execute(expected);
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Assert.assertEquals((Collection)actualResults.getTypes(), (Collection)expectedResults.getTypes(), (String)("Types mismatch for query: \n " + actual + "\n:"));
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
        }
    }

    public static void assertContains(MaterializedResult all, MaterializedResult expectedSubset) {
        for (MaterializedRow row : expectedSubset.getMaterializedRows()) {
            if (all.getMaterializedRows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all, (int)100)), expectedSubset.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset, (int)100))));
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String query) {
        MaterializedResult actualResults = this.runner.execute(this.runner.getDefaultSession(), query).toTestTypes();
        return actualResults;
    }

    @Override
    public void close() {
        this.runner.close();
    }
}

