/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.MaterializedResult;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFullJoin {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testFullJoinWithLimit() {
        MaterializedResult actual = this.assertions.execute("SELECT * FROM (VALUES 1, 2) AS l(v) FULL OUTER JOIN (VALUES 2, 1) AS r(v) ON l.v = r.v LIMIT 1");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)1);
        QueryAssertions.assertContains(this.assertions.execute("VALUES (1,1), (2,2)"), actual);
        this.assertions.assertQuery("SELECT * FROM (VALUES 1, 2) AS l(v) FULL OUTER JOIN (VALUES 2) AS r(v) ON l.v = r.v ORDER BY l.v NULLS FIRST LIMIT 1", "VALUES (1, CAST(NULL AS INTEGER))");
        this.assertions.assertQuery("SELECT * FROM (VALUES 2) AS l(v) FULL OUTER JOIN (VALUES 1, 2) AS r(v) ON l.v = r.v ORDER BY r.v NULLS FIRST LIMIT 1", "VALUES (CAST(NULL AS INTEGER), 1)");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)1);
        QueryAssertions.assertContains(this.assertions.execute("VALUES (1,1), (2,2)"), actual);
    }
}

