/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.Session;
import io.prestosql.spi.security.Identity;
import io.prestosql.sql.SqlPath;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.TestingSession;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSessionFunctions {
    @Test
    public void testCurrentUser() {
        Session session = TestingSession.testSessionBuilder().setIdentity(new Identity("test_current_user", Optional.empty())).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            queryAssertions.assertQuery("SELECT CURRENT_USER", "SELECT CAST('" + session.getUser() + "' AS VARCHAR)");
        }
    }

    @Test
    public void testCurrentPath() {
        Session session = TestingSession.testSessionBuilder().setPath(new SqlPath(Optional.of("testPath"))).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            queryAssertions.assertQuery("SELECT CURRENT_PATH", "SELECT CAST('" + session.getPath().toString() + "' AS VARCHAR)");
        }
        Session emptyPathSession = TestingSession.testSessionBuilder().setPath(new SqlPath(Optional.empty())).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(emptyPathSession);){
            queryAssertions.assertQuery("SELECT CURRENT_PATH", "VALUES VARCHAR ''");
        }
    }
}

