/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.DeterminismEvaluator;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.RowExpression;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    @Test
    public void testDeterminismEvaluator() {
        DeterminismEvaluator determinismEvaluator = new DeterminismEvaluator(MetadataManager.createTestMetadataManager().getFunctionRegistry());
        CallExpression random = new CallExpression(new Signature("random", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)random));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        Signature lessThan = Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression lessThanExpression = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanExpression));
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)random));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
    }
}

