/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.prestosql.SessionTestUtils;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.informationschema.InformationSchemaConnector;
import io.prestosql.connector.system.SystemConnector;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.CatalogMetadata;
import io.prestosql.metadata.InMemoryNodeManager;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.testing.TestingConnectorContext;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionInfo;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.transaction.TransactionManagerConfig;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestTransactionManager {
    private static final String CATALOG = "test_catalog";
    private static final CatalogName CATALOG_NAME = new CatalogName("test_catalog");
    private static final CatalogName SYSTEM_TABLES_ID = CatalogName.createSystemTablesCatalogName((CatalogName)CATALOG_NAME);
    private static final CatalogName INFORMATION_SCHEMA_ID = CatalogName.createInformationSchemaCatalogName((CatalogName)CATALOG_NAME);
    private final ExecutorService finishingExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.finishingExecutor.shutdownNow();
    }

    @Test
    public void testTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testAbortedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testFailedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.fail(transactionId);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            try {
                transactionManager.getCatalogMetadata(transactionId, CATALOG_NAME);
                Assert.fail();
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.TRANSACTION_ALREADY_ABORTED.toErrorCode());
            }
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testExpiration() throws Exception {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MILLISECONDS)).setIdleCheckInterval(new Duration(5.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)new CatalogManager(), (ExecutorService)this.finishingExecutor);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.trySetInactive(transactionId);
            TimeUnit.MILLISECONDS.sleep(100L);
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    private static void registerConnector(CatalogManager catalogManager, TransactionManager transactionManager, String catalogName, CatalogName catalog, Connector connector) {
        CatalogName systemId = CatalogName.createSystemTablesCatalogName((CatalogName)catalog);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        catalogManager.registerCatalog(new Catalog(catalogName, catalog, connector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()), systemId, (Connector)new SystemConnector((InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, catalog))));
    }

    private static class IdleCheckExecutor
    implements Closeable {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"idle-check"));

        private IdleCheckExecutor() {
        }

        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        @Override
        public void close() {
            this.executorService.shutdownNow();
        }
    }
}

