/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.SqlIntervalDayTime;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIntervalDayTime
extends AbstractTestFunctions {
    @Test
    public void testObject() {
        Assert.assertEquals((Object)new SqlIntervalDayTime(12, 10, 45, 32, 123), (Object)new SqlIntervalDayTime(1075532123L));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-12, -10, -45, -32, -123), (Object)new SqlIntervalDayTime(-1075532123L));
        Assert.assertEquals((Object)new SqlIntervalDayTime(30, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(TimeUnit.DAYS.toMillis(30L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-30, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(-TimeUnit.DAYS.toMillis(30L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(90, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(TimeUnit.DAYS.toMillis(90L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-90, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(-TimeUnit.DAYS.toMillis(90L)));
    }

    @Test
    public void testLiteral() {
        this.assertLiteral("INTERVAL '12 10:45:32.123' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 45, 32, 123));
        this.assertLiteral("INTERVAL '12 10:45:32.12' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 45, 32, 120));
        this.assertLiteral("INTERVAL '12 10:45:32' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 45, 32, 0));
        this.assertLiteral("INTERVAL '12 10:45' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 45, 0, 0));
        this.assertLiteral("INTERVAL '12 10' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '12' DAY TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '12 10:45' DAY TO MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 45, 0, 0));
        this.assertLiteral("INTERVAL '12 10' DAY TO MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '12' DAY TO MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '12 10' DAY TO HOUR", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '12' DAY TO HOUR", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '12' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '30' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(30, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '90' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(90, 0, 0, 0, 0));
        this.assertLiteral("INTERVAL '10:45:32.123' HOUR TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 45, 32, 123));
        this.assertLiteral("INTERVAL '10:45:32.12' HOUR TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 45, 32, 120));
        this.assertLiteral("INTERVAL '10:45:32' HOUR TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 45, 32, 0));
        this.assertLiteral("INTERVAL '10:45' HOUR TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 45, 0, 0));
        this.assertLiteral("INTERVAL '10' HOUR TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '10:45' HOUR TO MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 45, 0, 0));
        this.assertLiteral("INTERVAL '10' HOUR TO MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '10' HOUR", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertLiteral("INTERVAL '45:32.123' MINUTE TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 45, 32, 123));
        this.assertLiteral("INTERVAL '45:32.12' MINUTE TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 45, 32, 120));
        this.assertLiteral("INTERVAL '45:32' MINUTE TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 45, 32, 0));
        this.assertLiteral("INTERVAL '45' MINUTE TO SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 45, 0, 0));
        this.assertLiteral("INTERVAL '45' MINUTE", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 45, 0, 0));
        this.assertLiteral("INTERVAL '32.123' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 32, 123));
        this.assertLiteral("INTERVAL '32.12' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 32, 120));
        this.assertLiteral("INTERVAL '32' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 32, 0));
    }

    private void assertLiteral(String projection, Type expectedType, SqlIntervalDayTime expectedValue) {
        this.assertFunction(projection, expectedType, expectedValue);
        projection = projection.replace("INTERVAL '", "INTERVAL '-");
        expectedValue = new SqlIntervalDayTime(-expectedValue.getMillis());
        this.assertFunction(projection, expectedType, expectedValue);
    }

    @Test
    public void testInvalidLiteral() {
        this.assertInvalidFunction("INTERVAL '12X' DAY", "Invalid INTERVAL DAY value: 12X");
        this.assertInvalidFunction("INTERVAL '12 10' DAY", "Invalid INTERVAL DAY value: 12 10");
        this.assertInvalidFunction("INTERVAL '12 X' DAY TO HOUR", "Invalid INTERVAL DAY TO HOUR value: 12 X");
        this.assertInvalidFunction("INTERVAL '12 -10' DAY TO HOUR", "Invalid INTERVAL DAY TO HOUR value: 12 -10");
        this.assertInvalidFunction("INTERVAL '--12 -10' DAY TO HOUR", "Invalid INTERVAL DAY TO HOUR value: --12 -10");
    }

    @Test
    public void testAdd() {
        this.assertFunction("INTERVAL '3' SECOND + INTERVAL '3' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(6000L));
        this.assertFunction("INTERVAL '6' DAY + INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1036800000L));
        this.assertFunction("INTERVAL '3' SECOND + INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(518403000L));
    }

    @Test
    public void testSubtract() {
        this.assertFunction("INTERVAL '6' SECOND - INTERVAL '3' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(3000L));
        this.assertFunction("INTERVAL '9' DAY - INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(259200000L));
        this.assertFunction("INTERVAL '3' SECOND - INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(-518397000L));
    }

    @Test
    public void testMultiply() {
        this.assertFunction("INTERVAL '6' SECOND * 2", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12000L));
        this.assertFunction("2 * INTERVAL '6' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(12000L));
        this.assertFunction("INTERVAL '1' SECOND * 2.5", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(2500L));
        this.assertFunction("2.5 * INTERVAL '1' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(2500L));
        this.assertFunction("INTERVAL '6' DAY * 2", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1036800000L));
        this.assertFunction("2 * INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1036800000L));
        this.assertFunction("INTERVAL '1' DAY * 2.5", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(216000000L));
        this.assertFunction("2.5 * INTERVAL '1' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(216000000L));
    }

    @Test
    public void testDivide() {
        this.assertFunction("INTERVAL '3' SECOND / 2", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1500L));
        this.assertFunction("INTERVAL '6' SECOND / 2.5", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(2400L));
        this.assertFunction("INTERVAL '3' DAY / 2", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(129600000L));
        this.assertFunction("INTERVAL '4' DAY / 2.5", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(138240000L));
    }

    @Test
    public void testNegation() {
        this.assertFunction("- INTERVAL '3' SECOND", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(-3000L));
        this.assertFunction("- INTERVAL '6' DAY", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(-518400000L));
    }

    @Test
    public void testEqual() {
        this.assertFunction("INTERVAL '3' SECOND = INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY = INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND = INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '7' DAY = INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("INTERVAL '3' SECOND <> INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY <> INTERVAL '7' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND <> INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY <> INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '7' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '5' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '7' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '5' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '5' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '7' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '5' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '6' DAY", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '7' DAY", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '2' SECOND and INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '3' SECOND and INTERVAL '4' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '2' SECOND and INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '3' SECOND and INTERVAL '3' SECOND", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '4' SECOND and INTERVAL '5' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '1' SECOND and INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '4' SECOND and INTERVAL '2' SECOND", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(INTERVAL '12 10:45:32.123' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, "12 10:45:32.123");
        this.assertFunction("cast(INTERVAL '12 10:45:32.123' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '12 10:45:32.12' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '12 10:45:32' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10:45' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10:45' DAY TO MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO HOUR as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO HOUR as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45:32.123' HOUR TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '10:45:32.12' HOUR TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '10:45:32' HOUR TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45' HOUR TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45' HOUR TO MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR TO MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '45:32.123' MINUTE TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '45:32.12' MINUTE TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '45:32' MINUTE TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '45' MINUTE TO SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '45' MINUTE as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '32.123' SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 0, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '32.12' SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 0, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '32' SECOND as varchar)", (Type)VarcharType.VARCHAR, new SqlIntervalDayTime(0, 0, 0, 32, 0).toString());
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as INTERVAL DAY TO SECOND)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "INTERVAL '45' MINUTE TO SECOND", (Type)BooleanType.BOOLEAN, false);
    }
}

