/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.io.BaseEncoding;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.IpAddressType;
import org.testng.annotations.Test;

public class TestIpAddressOperators
extends AbstractTestFunctions {
    @Test
    public void testVarcharToIpAddressCast() {
        this.assertFunction("CAST('::ffff:1.2.3.4' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("CAST('192.168.0.0' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "192.168.0.0");
        this.assertFunction("CAST('2001:0db8:0000:0000:0000:ff00:0042:8329' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::ff00:42:8329");
        this.assertFunction("CAST('2001:db8::ff00:42:8329' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::ff00:42:8329");
        this.assertFunction("CAST('2001:db8:0:0:1:0:0:1' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::1:0:0:1");
        this.assertFunction("CAST('2001:db8:0:0:1::1' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::1:0:0:1");
        this.assertFunction("CAST('2001:db8::1:0:0:1' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::1:0:0:1");
        this.assertFunction("CAST('2001:DB8::FF00:ABCD:12EF' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::ff00:abcd:12ef");
        this.assertFunction("IPADDRESS '10.0.0.0'", (Type)IpAddressType.IPADDRESS, "10.0.0.0");
        this.assertFunction("IPADDRESS '64:ff9b::10.0.0.0'", (Type)IpAddressType.IPADDRESS, "64:ff9b::a00:0");
        this.assertInvalidCast("CAST('facebook.com' AS IPADDRESS)", "Cannot cast value to IPADDRESS: facebook.com");
        this.assertInvalidCast("CAST('localhost' AS IPADDRESS)", "Cannot cast value to IPADDRESS: localhost");
        this.assertInvalidCast("CAST('2001:db8::1::1' AS IPADDRESS)", "Cannot cast value to IPADDRESS: 2001:db8::1::1");
        this.assertInvalidCast("CAST('2001:zxy::1::1' AS IPADDRESS)", "Cannot cast value to IPADDRESS: 2001:zxy::1::1");
        this.assertInvalidCast("CAST('789.1.1.1' AS IPADDRESS)", "Cannot cast value to IPADDRESS: 789.1.1.1");
    }

    @Test
    public void testIpAddressToVarcharCast() {
        this.assertFunction("CAST(IPADDRESS '::ffff:1.2.3.4' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4");
        this.assertFunction("CAST(IPADDRESS '::ffff:102:304' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4");
        this.assertFunction("CAST(IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::ff00:42:8329");
        this.assertFunction("CAST(IPADDRESS '2001:db8::ff00:42:8329' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::ff00:42:8329");
        this.assertFunction("CAST(IPADDRESS '2001:db8:0:0:1:0:0:1' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::1:0:0:1");
        this.assertFunction("CAST(CAST('1.2.3.4' AS IPADDRESS) AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4");
        this.assertFunction("CAST(CAST('2001:db8:0:0:1::1' AS IPADDRESS) AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::1:0:0:1");
        this.assertFunction("CAST(CAST('64:ff9b::10.0.0.0' AS IPADDRESS) AS VARCHAR)", (Type)VarcharType.VARCHAR, "64:ff9b::a00:0");
    }

    @Test
    public void testVarbinaryToIpAddressCast() {
        this.assertFunction("CAST(x'00000000000000000000ffff01020304' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("CAST(x'01020304' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("CAST(x'c0a80000' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "192.168.0.0");
        this.assertFunction("CAST(x'20010db8000000000000ff0000428329' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::ff00:42:8329");
        this.assertInvalidCast("CAST(x'f000001100' AS IPADDRESS)", "Invalid IP address binary length: 5");
    }

    @Test
    public void testIpAddressToVarbinaryCast() {
        this.assertFunction("CAST(IPADDRESS '::ffff:1.2.3.4' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)"00000000000000000000FFFF01020304")));
        this.assertFunction("CAST(IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)"20010DB8000000000000FF0000428329")));
        this.assertFunction("CAST(IPADDRESS '2001:db8::ff00:42:8329' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, new SqlVarbinary(BaseEncoding.base16().decode((CharSequence)"20010DB8000000000000FF0000428329")));
    }

    @Test
    public void testEquals() {
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' = IPADDRESS '2001:db8::ff00:42:8329'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) = CAST('::ffff:1.2.3.4' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '192.168.0.0' = IPADDRESS '::ffff:192.168.0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '10.0.0.0' = IPADDRESS '::ffff:a00:0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '2001:db8::ff00:42:8329' = IPADDRESS '2001:db8::ff00:42:8300'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) = IPADDRESS '1.2.3.5'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' IS DISTINCT FROM IPADDRESS '2001:db8::ff00:42:8329'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS IPADDRESS) IS DISTINCT FROM CAST(NULL AS IPADDRESS)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' IS DISTINCT FROM IPADDRESS '2001:db8::ff00:42:8328'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' IS DISTINCT FROM CAST(NULL AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS IPADDRESS) IS DISTINCT FROM IPADDRESS '2001:db8::ff00:42:8328'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' != IPADDRESS '1.2.3.4'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) <> CAST('1.2.3.5' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) != IPADDRESS '1.2.3.4'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' <> IPADDRESS '2001:db8::ff00:42:8329'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) <> CAST('::ffff:1.2.3.4' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testOrderOperators() {
        this.assertFunction("IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329' > IPADDRESS '1.2.3.4'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '1.2.3.4' > IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4' AS IPADDRESS) < CAST('1.2.3.5' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.5' AS IPADDRESS) < CAST('1.2.3.4' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPADDRESS '::1' <= CAST('1.2.3.5' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '1.2.3.5' <= CAST('1.2.3.5' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '1.2.3.6' <= CAST('1.2.3.5' AS IPADDRESS)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPADDRESS '::1' >= IPADDRESS '::'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '::1' >= IPADDRESS '::1'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '::' >= IPADDRESS '::1'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPADDRESS '::1' BETWEEN IPADDRESS '::' AND IPADDRESS '::1234'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPADDRESS '::2222' BETWEEN IPADDRESS '::' AND IPADDRESS '::1234'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "CAST(null AS IPADDRESS)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "IPADDRESS '::2222'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testHash() {
        this.assertOperator(OperatorType.HASH_CODE, "CAST(null AS IPADDRESS)", (Type)BigintType.BIGINT, null);
        this.assertOperator(OperatorType.HASH_CODE, "IPADDRESS '::2222'", (Type)BigintType.BIGINT, TestIpAddressOperators.hashFromType("::2222"));
    }

    private static long hashFromType(String address) {
        BlockBuilder blockBuilder = IpAddressType.IPADDRESS.createBlockBuilder(null, 1);
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])InetAddresses.forString((String)address).getAddress()));
        Block block = blockBuilder.build();
        return IpAddressType.IPADDRESS.hash(block, 0);
    }
}

