/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RowBlockBuilder;
import io.prestosql.spi.block.SingleRowBlockWriter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.AbstractTestType;
import io.prestosql.type.TypeRegistry;
import java.util.List;

public class TestSimpleRowType
extends AbstractTestType {
    private static final Type TYPE = new TypeRegistry().getType(TypeSignature.parseTypeSignature((String)"row(a bigint,b varchar)"));

    public TestSimpleRowType() {
        super(TYPE, List.class, TestSimpleRowType.createTestBlock());
    }

    private static Block createTestBlock() {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 3);
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cat"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 2L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cats"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 3L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"dog"));
        blockBuilder.closeEntry();
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 1);
        Block block = (Block)value;
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(0).getLong(0, 0) + 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(1).getSlice(0, 0, 1));
        blockBuilder.closeEntry();
        return TYPE.getObject(blockBuilder.build(), 0);
    }
}

