/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import java.util.Random;

public final class HashCollisionsSimulator {
    private static final int NUMBER_OF_ESTIMATES = 500;
    private static final int NUMBER_OF_PROBES = 500;
    private static final int NUMBER_OF_VALUES = 10000;

    public static void main(String[] args) {
        HashCollisionsSimulator.generateEstimates();
    }

    private static void generateEstimates() {
        System.out.print("0.0, ");
        for (int i = 1; i <= 500; ++i) {
            int hashSize = 5000000 / i;
            System.out.print(HashCollisionsSimulator.simulate(10000, hashSize));
            if (i >= 500) continue;
            System.out.print(", ");
        }
    }

    private static double simulate(int numberOfValues, int hashSize) {
        int collisions = 0;
        for (int i = 0; i < 500; ++i) {
            collisions += HashCollisionsSimulator.simulationIteration(numberOfValues, hashSize);
        }
        return (double)collisions / 500.0;
    }

    public static double simulate(int numberOfValues, int hashSize, int iterations) {
        int collisions = 0;
        for (int i = 0; i < iterations; ++i) {
            collisions += HashCollisionsSimulator.simulationIteration(numberOfValues, hashSize);
        }
        return (double)collisions / (double)iterations;
    }

    private static int simulationIteration(int numberOfValues, int hashSize) {
        int collisions = 0;
        Random random = new Random();
        boolean[] cells = new boolean[hashSize];
        for (int i = 0; i < numberOfValues; ++i) {
            int pos = random.nextInt(hashSize);
            while (cells[pos]) {
                ++collisions;
                pos = (pos + 1) % hashSize;
            }
            cells[pos] = true;
        }
        return collisions;
    }

    private HashCollisionsSimulator() {
    }
}

