/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.type.TypeRegistry;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public final class StructuralTestUtil {
    private static final TypeManager TYPE_MANAGER = new TypeRegistry();

    private StructuralTestUtil() {
    }

    public static Block arrayBlockOf(Type elementType, Object ... values) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, values.length);
        for (Object value : values) {
            StructuralTestUtil.appendToBlockBuilder(elementType, value, blockBuilder);
        }
        return blockBuilder.build();
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Map<?, ?> value) {
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder mapArrayBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder singleMapWriter = mapArrayBuilder.beginBlockEntry();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            StructuralTestUtil.appendToBlockBuilder(keyType, entry.getKey(), singleMapWriter);
            StructuralTestUtil.appendToBlockBuilder(valueType, entry.getValue(), singleMapWriter);
        }
        mapArrayBuilder.closeEntry();
        return mapType.getObject((Block)mapArrayBuilder, 0);
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }

    public static void appendToBlockBuilder(Type type, Object element, BlockBuilder blockBuilder) {
        Class javaType = type.getJavaType();
        if (element == null) {
            blockBuilder.appendNull();
        } else if (type.getTypeSignature().getBase().equals("array") && element instanceof Iterable) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object subElement : (Iterable)element) {
                StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(0), subElement, subBlockBuilder);
            }
            blockBuilder.closeEntry();
        } else if (type.getTypeSignature().getBase().equals("row") && element instanceof Iterable) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            int field = 0;
            for (Object subElement : (Iterable)element) {
                StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(field), subElement, subBlockBuilder);
                ++field;
            }
            blockBuilder.closeEntry();
        } else if (type.getTypeSignature().getBase().equals("map") && element instanceof Map) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : ((Map)element).entrySet()) {
                StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(0), entry.getKey(), subBlockBuilder);
                StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(1), entry.getValue(), subBlockBuilder);
            }
            blockBuilder.closeEntry();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
        } else if (javaType == Long.TYPE) {
            if (element instanceof SqlDecimal) {
                type.writeLong(blockBuilder, ((SqlDecimal)element).getUnscaledValue().longValue());
            } else if (RealType.REAL.equals((Object)type)) {
                type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(((Number)element).floatValue()));
            } else {
                type.writeLong(blockBuilder, ((Number)element).longValue());
            }
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)element).doubleValue());
        } else if (javaType == Slice.class) {
            if (element instanceof String) {
                type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
            } else if (element instanceof byte[]) {
                type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])element)));
            } else if (element instanceof SqlDecimal) {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)element).getUnscaledValue()));
            } else {
                type.writeSlice(blockBuilder, (Slice)element);
            }
        } else {
            type.writeObject(blockBuilder, element);
        }
    }

    static {
        new FunctionRegistry(TYPE_MANAGER, (BlockEncodingSerde)new BlockEncodingManager(TYPE_MANAGER, new BlockEncoding[0]), new FeaturesConfig());
    }
}

