/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.airlift.jodabridge.JdkBasedZoneInfoProvider;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.ZoneId;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimeZoneUtils {
    @BeforeClass
    protected void validateJodaZoneInfoProvider() {
        try {
            JdkBasedZoneInfoProvider.registerAsJodaZoneInfoProvider();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Set the following system property to JVM running the test: -Dorg.joda.time.DateTimeZone.Provider=io.airlift.jodabridge.JdkBasedZoneInfoProvider");
        }
    }

    @Test
    public void test() {
        DateTimeZone dateTimeZone;
        TimeZoneKey.getTimeZoneKey((String)"GMT-13:00");
        TreeSet jodaZones = new TreeSet(DateTimeZone.getAvailableIDs());
        TreeSet<String> jdkZones = new TreeSet<String>(ZoneId.getAvailableZoneIds());
        Assert.assertEquals(jodaZones, jdkZones);
        for (String zoneId : new TreeSet<String>((SortedSet<String>)jdkZones)) {
            if (zoneId.startsWith("Etc/") || zoneId.startsWith("GMT") || zoneId.startsWith("SystemV/") || zoneId.equals("Canada/East-Saskatchewan")) continue;
            dateTimeZone = DateTimeZone.forID((String)zoneId);
            DateTimeZone indexedZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zoneId));
            TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, indexedZone);
            TestTimeZoneUtils.assertTimeZone(zoneId, dateTimeZone);
        }
        for (int offsetHours = -13; offsetHours < 14; ++offsetHours) {
            for (int offsetMinutes = 0; offsetMinutes < 60; ++offsetMinutes) {
                dateTimeZone = DateTimeZone.forOffsetHoursMinutes((int)offsetHours, (int)offsetMinutes);
                TestTimeZoneUtils.assertTimeZone(dateTimeZone.getID(), dateTimeZone);
            }
        }
    }

    public static void assertTimeZone(String zoneId, DateTimeZone dateTimeZone) {
        long dateTimeWithTimeZone = DateTimeZoneIndex.packDateTimeWithZone((DateTime)new DateTime(42L, dateTimeZone));
        Assert.assertEquals((long)DateTimeEncoding.packDateTimeWithZone((long)42L, (String)dateTimeZone.toTimeZone().getID()), (long)dateTimeWithTimeZone);
        DateTimeZone unpackedZone = DateTimeZoneIndex.unpackDateTimeZone((long)dateTimeWithTimeZone);
        TestTimeZoneUtils.assertDateTimeZoneEquals(zoneId, unpackedZone);
    }

    public static void assertDateTimeZoneEquals(String zoneId, DateTimeZone actualTimeZone) {
        DateTimeZone expectedDateTimeZone = TimeZoneKey.isUtcZoneId((String)zoneId) ? DateTimeZone.UTC : DateTimeZone.forID((String)zoneId);
        Assert.assertEquals((Object)actualTimeZone, (Object)expectedDateTimeZone);
    }
}

