/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.session.ResourceEstimates;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.sql.SqlPath;
import io.prestosql.transaction.TransactionId;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SessionRepresentation {
    private final String queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String user;
    private final Optional<String> principal;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final SqlPath path;
    private final Optional<String> traceToken;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final long startTime;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<CatalogName, Map<String, String>> catalogProperties;
    private final Map<String, Map<String, String>> unprocessedCatalogProperties;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> preparedStatements;

    @JsonCreator
    public SessionRepresentation(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="transactionId") Optional<TransactionId> transactionId, @JsonProperty(value="clientTransactionSupport") boolean clientTransactionSupport, @JsonProperty(value="user") String user, @JsonProperty(value="principal") Optional<String> principal, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="path") SqlPath path, @JsonProperty(value="traceToken") Optional<String> traceToken, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") Optional<String> remoteUserAddress, @JsonProperty(value="userAgent") Optional<String> userAgent, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="clientTags") Set<String> clientTags, @JsonProperty(value="clientCapabilities") Set<String> clientCapabilities, @JsonProperty(value="resourceEstimates") ResourceEstimates resourceEstimates, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<CatalogName, Map<String, String>> catalogProperties, @JsonProperty(value="unprocessedCatalogProperties") Map<String, Map<String, String>> unprocessedCatalogProperties, @JsonProperty(value="roles") Map<String, SelectedRole> roles, @JsonProperty(value="preparedStatements") Map<String, String> preparedStatements) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.clientCapabilities = Objects.requireNonNull(clientCapabilities, "clientCapabilities is null");
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.roles = ImmutableMap.copyOf(roles);
        this.preparedStatements = ImmutableMap.copyOf(preparedStatements);
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<CatalogName, Map<String, String>> entry : catalogProperties.entrySet()) {
            catalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.catalogProperties = catalogPropertiesBuilder.build();
        ImmutableMap.Builder unprocessedCatalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : unprocessedCatalogProperties.entrySet()) {
            unprocessedCatalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.unprocessedCatalogProperties = unprocessedCatalogPropertiesBuilder.build();
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public SqlPath getPath() {
        return this.path;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @JsonProperty
    public Map<CatalogName, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getUnprocessedCatalogProperties() {
        return this.unprocessedCatalogProperties;
    }

    @JsonProperty
    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    @JsonProperty
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager) {
        return this.toSession(sessionPropertyManager, Collections.emptyMap());
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager, Map<String, String> extraCredentials) {
        return new Session(new QueryId(this.queryId), this.transactionId, this.clientTransactionSupport, new Identity(this.user, this.principal.map(BasicPrincipal::new), this.roles, extraCredentials), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.startTime, this.systemProperties, this.catalogProperties, this.unprocessedCatalogProperties, sessionPropertyManager, this.preparedStatements);
    }
}

