/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.memory.MemoryManagerConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class SystemSessionProperties {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String JOIN_DISTRIBUTION_TYPE = "join_distribution_type";
    public static final String JOIN_MAX_BROADCAST_TABLE_SIZE = "join_max_broadcast_table_size";
    public static final String DISTRIBUTED_INDEX_JOIN = "distributed_index_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String GROUPED_EXECUTION = "grouped_execution";
    public static final String DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION = "dynamic_schedule_for_grouped_execution";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_CONCURRENCY = "task_concurrency";
    public static final String TASK_SHARE_INDEX_LOADING = "task_share_index_loading";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY = "query_max_total_memory";
    public static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    public static final String QUERY_MAX_RUN_TIME = "query_max_run_time";
    public static final String RESOURCE_OVERCOMMIT = "resource_overcommit";
    public static final String QUERY_MAX_CPU_TIME = "query_max_cpu_time";
    public static final String QUERY_MAX_STAGE_COUNT = "query_max_stage_count";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    public static final String SCALE_WRITERS = "scale_writers";
    public static final String WRITER_MIN_SIZE = "writer_min_size";
    public static final String PUSH_TABLE_WRITE_THROUGH_UNION = "push_table_write_through_union";
    public static final String EXECUTION_POLICY = "execution_policy";
    public static final String DICTIONARY_AGGREGATION = "dictionary_aggregation";
    public static final String PLAN_WITH_TABLE_NODE_PARTITIONING = "plan_with_table_node_partitioning";
    public static final String SPATIAL_JOIN = "spatial_join";
    public static final String SPATIAL_PARTITIONING_TABLE_NAME = "spatial_partitioning_table_name";
    public static final String COLOCATED_JOIN = "colocated_join";
    public static final String CONCURRENT_LIFESPANS_PER_NODE = "concurrent_lifespans_per_task";
    public static final String REORDER_JOINS = "reorder_joins";
    public static final String JOIN_REORDERING_STRATEGY = "join_reordering_strategy";
    public static final String MAX_REORDERED_JOINS = "max_reordered_joins";
    public static final String INITIAL_SPLITS_PER_NODE = "initial_splits_per_node";
    public static final String SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL = "split_concurrency_adjustment_interval";
    public static final String OPTIMIZE_METADATA_QUERIES = "optimize_metadata_queries";
    public static final String FAST_INEQUALITY_JOINS = "fast_inequality_joins";
    public static final String QUERY_PRIORITY = "query_priority";
    public static final String SPILL_ENABLED = "spill_enabled";
    public static final String SPILL_ORDER_BY = "spill_order_by";
    public static final String SPILL_WINDOW_OPERATOR = "spill_window_operator";
    public static final String AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT = "aggregation_operator_unspill_memory_limit";
    public static final String OPTIMIZE_DISTINCT_AGGREGATIONS = "optimize_mixed_distinct_aggregations";
    public static final String ITERATIVE_OPTIMIZER = "iterative_optimizer_enabled";
    public static final String ITERATIVE_OPTIMIZER_TIMEOUT = "iterative_optimizer_timeout";
    public static final String ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID = "enable_forced_exchange_below_group_id";
    public static final String EXCHANGE_COMPRESSION = "exchange_compression";
    public static final String LEGACY_TIMESTAMP = "legacy_timestamp";
    public static final String ENABLE_INTERMEDIATE_AGGREGATIONS = "enable_intermediate_aggregations";
    public static final String PUSH_AGGREGATION_THROUGH_JOIN = "push_aggregation_through_join";
    public static final String PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN = "push_partial_aggregation_through_join";
    public static final String PARSE_DECIMAL_LITERALS_AS_DOUBLE = "parse_decimal_literals_as_double";
    public static final String FORCE_SINGLE_NODE_OUTPUT = "force_single_node_output";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = "filter_and_project_min_output_page_size";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = "filter_and_project_min_output_page_row_count";
    public static final String DISTRIBUTED_SORT = "distributed_sort";
    public static final String USE_MARK_DISTINCT = "use_mark_distinct";
    public static final String PREFER_PARTIAL_AGGREGATION = "prefer_partial_aggregation";
    public static final String OPTIMIZE_TOP_N_ROW_NUMBER = "optimize_top_n_row_number";
    public static final String MAX_GROUPING_SETS = "max_grouping_sets";
    public static final String STATISTICS_CPU_TIMER_ENABLED = "statistics_cpu_timer_enabled";
    public static final String ENABLE_STATS_CALCULATOR = "enable_stats_calculator";
    public static final String IGNORE_STATS_CALCULATOR_FAILURES = "ignore_stats_calculator_failures";
    public static final String MAX_DRIVERS_PER_TASK = "max_drivers_per_task";
    public static final String DEFAULT_FILTER_FACTOR_ENABLED = "default_filter_factor_enabled";
    public static final String WORK_PROCESSOR_PIPELINES = "work_processor_pipelines";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXECUTION_POLICY, (String)"Policy used for scheduling query tasks", (String)queryManagerConfig.getQueryExecutionPolicy(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)featuresConfig.isOptimizeHashGeneration(), (boolean)false), (Object)new PropertyMetadata(JOIN_DISTRIBUTION_TYPE, String.format("The join method to use. Options are %s", Stream.of(FeaturesConfig.JoinDistributionType.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinDistributionType.class, (Object)featuresConfig.getJoinDistributionType(), false, value -> FeaturesConfig.JoinDistributionType.valueOf(((String)value).toUpperCase()), Enum::name), (Object)new PropertyMetadata(JOIN_MAX_BROADCAST_TABLE_SIZE, "Maximum estimated size of a table that can be broadcast when using automatic join type selection", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getJoinMaxBroadcastTableSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_INDEX_JOIN, (String)"Distribute index joins on join keys instead of executing inline", (Boolean)featuresConfig.isDistributedIndexJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getInitialHashPartitions(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)GROUPED_EXECUTION, (String)"Use grouped execution when possible", (Boolean)featuresConfig.isGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION, (String)"Experimental: Use dynamic schedule for grouped execution when possible", (Boolean)featuresConfig.isDynamicScheduleForGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), (Object)new PropertyMetadata(TASK_WRITER_COUNT, "Default number of local parallel table writer jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getWriterCount(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_WRITER_COUNT), value -> value), (Object)PropertyMetadata.booleanProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)SCALE_WRITERS, (String)"Scale out writers based on throughput (use minimum necessary)", (Boolean)featuresConfig.isScaleWriters(), (boolean)false), (Object[])new PropertyMetadata[]{new PropertyMetadata(WRITER_MIN_SIZE, "Target minimum size of writer output when scaling writers", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getWriterMinSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)PUSH_TABLE_WRITE_THROUGH_UNION, (String)"Parallelize writes when using UNION ALL in queries that write data", (Boolean)featuresConfig.isPushTableWriteThroughUnion(), (boolean)false), new PropertyMetadata(TASK_CONCURRENCY, "Default number of local parallel jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getTaskConcurrency(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_CONCURRENCY), value -> value), PropertyMetadata.booleanProperty((String)TASK_SHARE_INDEX_LOADING, (String)"Share index join lookups and caching within a task", (Boolean)taskManagerConfig.isShareIndexLoading(), (boolean)false), new PropertyMetadata(QUERY_MAX_RUN_TIME, "Maximum run time of a query (includes the queueing time)", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxRunTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_EXECUTION_TIME, "Maximum execution time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxExecutionTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_CPU_TIME, "Maximum CPU time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxCpuTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_MEMORY, "Maximum amount of distributed memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getMaxQueryMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_TOTAL_MEMORY, "Maximum amount of distributed total memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getMaxQueryTotalMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)RESOURCE_OVERCOMMIT, (String)"Use resources which are not guaranteed to be available to the query", (Boolean)false, (boolean)false), PropertyMetadata.integerProperty((String)QUERY_MAX_STAGE_COUNT, (String)"Temporary: Maximum number of stages a query can have", (Integer)queryManagerConfig.getMaxStageCount(), (boolean)true), PropertyMetadata.booleanProperty((String)DICTIONARY_AGGREGATION, (String)"Enable optimization for aggregations on dictionaries", (Boolean)featuresConfig.isDictionaryAggregation(), (boolean)false), PropertyMetadata.integerProperty((String)INITIAL_SPLITS_PER_NODE, (String)"The number of splits each node will run per task, initially", (Integer)taskManagerConfig.getInitialSplitsPerNode(), (boolean)false), new PropertyMetadata(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, "Experimental: Interval between changes to the number of concurrent splits per node", (Type)VarcharType.VARCHAR, Duration.class, (Object)taskManagerConfig.getSplitConcurrencyAdjustmentInterval(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_METADATA_QUERIES, (String)"Enable optimization for metadata queries", (Boolean)featuresConfig.isOptimizeMetadataQueries(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_PRIORITY, (String)"The priority of queries. Larger numbers are higher priority", (Integer)1, (boolean)false), PropertyMetadata.booleanProperty((String)PLAN_WITH_TABLE_NODE_PARTITIONING, (String)"Experimental: Adapt plan to pre-partitioned tables", (Boolean)true, (boolean)false), PropertyMetadata.booleanProperty((String)REORDER_JOINS, (String)"(DEPRECATED) Reorder joins to remove unnecessary cross joins. If this is set, join_reordering_strategy will be ignored", null, (boolean)false), new PropertyMetadata(JOIN_REORDERING_STRATEGY, String.format("The join reordering strategy to use. Options are %s", Stream.of(FeaturesConfig.JoinReorderingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinReorderingStrategy.class, (Object)featuresConfig.getJoinReorderingStrategy(), false, value -> FeaturesConfig.JoinReorderingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(MAX_REORDERED_JOINS, "The maximum number of joins to reorder as one group in cost-based join reordering", (Type)BigintType.BIGINT, Integer.class, (Object)featuresConfig.getMaxReorderedJoins(), false, value -> {
            int intValue = ((Number)Objects.requireNonNull(value, "value is null")).intValue();
            if (intValue < 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than or equal to 2: %s", MAX_REORDERED_JOINS, intValue));
            }
            return intValue;
        }, value -> value), PropertyMetadata.booleanProperty((String)FAST_INEQUALITY_JOINS, (String)"Use faster handling of inequality join if it is possible", (Boolean)featuresConfig.isFastInequalityJoins(), (boolean)false), PropertyMetadata.booleanProperty((String)COLOCATED_JOIN, (String)"Experimental: Use a colocated join when possible", (Boolean)featuresConfig.isColocatedJoinsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPATIAL_JOIN, (String)"Use spatial index for spatial join when possible", (Boolean)featuresConfig.isSpatialJoinsEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)SPATIAL_PARTITIONING_TABLE_NAME, (String)"Name of the table containing spatial partitioning scheme", null, (boolean)false), PropertyMetadata.integerProperty((String)CONCURRENT_LIFESPANS_PER_NODE, (String)"Experimental: Run a fixed number of groups concurrently for eligible JOINs", (Integer)featuresConfig.getConcurrentLifespansPerTask(), (boolean)false), new PropertyMetadata(SPILL_ENABLED, "Experimental: Enable spilling", (Type)BooleanType.BOOLEAN, Boolean.class, (Object)featuresConfig.isSpillEnabled(), false, value -> {
            boolean spillEnabled = (Boolean)value;
            if (spillEnabled && featuresConfig.getSpillerSpillPaths().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot be set to true; no spill paths configured", SPILL_ENABLED));
            }
            return spillEnabled;
        }, value -> value), PropertyMetadata.booleanProperty((String)SPILL_ORDER_BY, (String)"Spill in OrderBy if spill_enabled is also set", (Boolean)featuresConfig.isSpillOrderBy(), (boolean)false), PropertyMetadata.booleanProperty((String)SPILL_WINDOW_OPERATOR, (String)"Spill in WindowOperator if spill_enabled is also set", (Boolean)featuresConfig.isSpillWindowOperator(), (boolean)false), new PropertyMetadata(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, "Experimental: How much memory can should be allocated per aggragation operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getAggregationOperatorUnspillMemoryLimit(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_DISTINCT_AGGREGATIONS, (String)"Optimize mixed non-distinct and distinct aggregations", (Boolean)featuresConfig.isOptimizeMixedDistinctAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)ITERATIVE_OPTIMIZER, (String)"Experimental: enable iterative optimizer", (Boolean)featuresConfig.isIterativeOptimizerEnabled(), (boolean)false), new PropertyMetadata(ITERATIVE_OPTIMIZER_TIMEOUT, "Timeout for plan optimization in iterative optimizer", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getIterativeOptimizerTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID, (String)"Enable a stats-based rule adding exchanges below GroupId", (Boolean)featuresConfig.isEnableForcedExchangeBelowGroupId(), (boolean)true), PropertyMetadata.booleanProperty((String)EXCHANGE_COMPRESSION, (String)"Enable compression in exchanges", (Boolean)featuresConfig.isExchangeCompressionEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_TIMESTAMP, (String)"Use legacy TIME & TIMESTAMP semantics (warning: this will be removed)", (Boolean)featuresConfig.isLegacyTimestamp(), (boolean)true), PropertyMetadata.booleanProperty((String)ENABLE_INTERMEDIATE_AGGREGATIONS, (String)"Enable the use of intermediate aggregations", (Boolean)featuresConfig.isEnableIntermediateAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_AGGREGATION_THROUGH_JOIN, (String)"Allow pushing aggregations below joins", (Boolean)featuresConfig.isPushAggregationThroughJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, (String)"Push partial aggregations below joins", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)PARSE_DECIMAL_LITERALS_AS_DOUBLE, (String)"Parse decimal literals as DOUBLE instead of DECIMAL", (Boolean)featuresConfig.isParseDecimalLiteralsAsDouble(), (boolean)false), PropertyMetadata.booleanProperty((String)FORCE_SINGLE_NODE_OUTPUT, (String)"Force single node output", (Boolean)featuresConfig.isForceSingleNodeOutput(), (boolean)true), new PropertyMetadata(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, "Experimental: Minimum output page size for filter and project operators", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getFilterAndProjectMinOutputPageSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.integerProperty((String)FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, (String)"Experimental: Minimum output page row count for filter and project operators", (Integer)featuresConfig.getFilterAndProjectMinOutputPageRowCount(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTRIBUTED_SORT, (String)"Parallelize sort across multiple nodes", (Boolean)featuresConfig.isDistributedSortEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_MARK_DISTINCT, (String)"Implement DISTINCT aggregations using MarkDistinct", (Boolean)featuresConfig.isUseMarkDistinct(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_PARTIAL_AGGREGATION, (String)"Prefer splitting aggregations into partial and final stages", (Boolean)featuresConfig.isPreferPartialAggregation(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_TOP_N_ROW_NUMBER, (String)"Use top N row number optimization", (Boolean)featuresConfig.isOptimizeTopNRowNumber(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_GROUPING_SETS, (String)"Maximum number of grouping sets in a GROUP BY", (Integer)featuresConfig.getMaxGroupingSets(), (boolean)true), PropertyMetadata.booleanProperty((String)STATISTICS_CPU_TIMER_ENABLED, (String)"Experimental: Enable cpu time tracking for automatic column statistics collection on write", (Boolean)taskManagerConfig.isStatisticsCpuTimerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_CALCULATOR, (String)"Experimental: Enable statistics calculator", (Boolean)featuresConfig.isEnableStatsCalculator(), (boolean)false), new PropertyMetadata(MAX_DRIVERS_PER_TASK, "Maximum number of drivers per task", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> Math.min(taskManagerConfig.getMaxDriversPerTask(), SystemSessionProperties.validateNullablePositiveIntegerValue(value, MAX_DRIVERS_PER_TASK)), object -> object), PropertyMetadata.booleanProperty((String)IGNORE_STATS_CALCULATOR_FAILURES, (String)"Ignore statistics calculator failures", (Boolean)featuresConfig.isIgnoreStatsCalculatorFailures(), (boolean)false), PropertyMetadata.booleanProperty((String)DEFAULT_FILTER_FACTOR_ENABLED, (String)"use a default filter factor for unknown filters in a filter node", (Boolean)featuresConfig.isDefaultFilterFactorEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)WORK_PROCESSOR_PIPELINES, (String)"Experimental: Use WorkProcessor pipelines", (Boolean)featuresConfig.isWorkProcessorPipelines(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static String getExecutionPolicy(Session session) {
        return session.getSystemProperty(EXECUTION_POLICY, String.class);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static FeaturesConfig.JoinDistributionType getJoinDistributionType(Session session) {
        return session.getSystemProperty(JOIN_DISTRIBUTION_TYPE, FeaturesConfig.JoinDistributionType.class);
    }

    public static Optional<DataSize> getJoinMaxBroadcastTableSize(Session session) {
        return Optional.ofNullable(session.getSystemProperty(JOIN_MAX_BROADCAST_TABLE_SIZE, DataSize.class));
    }

    public static boolean isDistributedIndexJoinEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_INDEX_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getSystemProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static boolean isGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean isDynamicSchduleForGroupedExecution(Session session) {
        return session.getSystemProperty(DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getSystemProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getSystemProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getSystemProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static boolean isScaleWriters(Session session) {
        return session.getSystemProperty(SCALE_WRITERS, Boolean.class);
    }

    public static DataSize getWriterMinSize(Session session) {
        return session.getSystemProperty(WRITER_MIN_SIZE, DataSize.class);
    }

    public static boolean isPushTableWriteThroughUnion(Session session) {
        return session.getSystemProperty(PUSH_TABLE_WRITE_THROUGH_UNION, Boolean.class);
    }

    public static int getTaskConcurrency(Session session) {
        return session.getSystemProperty(TASK_CONCURRENCY, Integer.class);
    }

    public static boolean isShareIndexLoading(Session session) {
        return session.getSystemProperty(TASK_SHARE_INDEX_LOADING, Boolean.class);
    }

    public static boolean isDictionaryAggregationEnabled(Session session) {
        return session.getSystemProperty(DICTIONARY_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueries(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES, Boolean.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY, DataSize.class);
    }

    public static Duration getQueryMaxRunTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_RUN_TIME, Duration.class);
    }

    public static Duration getQueryMaxExecutionTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_EXECUTION_TIME, Duration.class);
    }

    public static boolean resourceOvercommit(Session session) {
        return session.getSystemProperty(RESOURCE_OVERCOMMIT, Boolean.class);
    }

    public static int getQueryMaxStageCount(Session session) {
        return session.getSystemProperty(QUERY_MAX_STAGE_COUNT, Integer.class);
    }

    public static boolean planWithTableNodePartitioning(Session session) {
        return session.getSystemProperty(PLAN_WITH_TABLE_NODE_PARTITIONING, Boolean.class);
    }

    public static boolean isFastInequalityJoin(Session session) {
        return session.getSystemProperty(FAST_INEQUALITY_JOINS, Boolean.class);
    }

    public static FeaturesConfig.JoinReorderingStrategy getJoinReorderingStrategy(Session session) {
        Boolean reorderJoins = session.getSystemProperty(REORDER_JOINS, Boolean.class);
        if (reorderJoins != null) {
            if (!reorderJoins.booleanValue()) {
                return FeaturesConfig.JoinReorderingStrategy.NONE;
            }
            return FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS;
        }
        return session.getSystemProperty(JOIN_REORDERING_STRATEGY, FeaturesConfig.JoinReorderingStrategy.class);
    }

    public static int getMaxReorderedJoins(Session session) {
        return session.getSystemProperty(MAX_REORDERED_JOINS, Integer.class);
    }

    public static boolean isColocatedJoinEnabled(Session session) {
        return session.getSystemProperty(COLOCATED_JOIN, Boolean.class);
    }

    public static boolean isSpatialJoinEnabled(Session session) {
        return session.getSystemProperty(SPATIAL_JOIN, Boolean.class);
    }

    public static Optional<String> getSpatialPartitioningTableName(Session session) {
        return Optional.ofNullable(session.getSystemProperty(SPATIAL_PARTITIONING_TABLE_NAME, String.class));
    }

    public static OptionalInt getConcurrentLifespansPerNode(Session session) {
        Integer result = session.getSystemProperty(CONCURRENT_LIFESPANS_PER_NODE, Integer.class);
        if (result == 0) {
            return OptionalInt.empty();
        }
        Preconditions.checkArgument((result > 0 ? 1 : 0) != 0, (Object)"Concurrent lifespans per node must be positive if set to non-zero");
        return OptionalInt.of(result);
    }

    public static int getInitialSplitsPerNode(Session session) {
        return session.getSystemProperty(INITIAL_SPLITS_PER_NODE, Integer.class);
    }

    public static int getQueryPriority(Session session) {
        Integer priority = session.getSystemProperty(QUERY_PRIORITY, Integer.class);
        Preconditions.checkArgument((priority > 0 ? 1 : 0) != 0, (Object)"Query priority must be positive");
        return priority;
    }

    public static Duration getSplitConcurrencyAdjustmentInterval(Session session) {
        return session.getSystemProperty(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, Duration.class);
    }

    public static Duration getQueryMaxCpuTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_CPU_TIME, Duration.class);
    }

    public static boolean isSpillEnabled(Session session) {
        return session.getSystemProperty(SPILL_ENABLED, Boolean.class);
    }

    public static boolean isSpillOrderBy(Session session) {
        return session.getSystemProperty(SPILL_ORDER_BY, Boolean.class);
    }

    public static boolean isSpillWindowOperator(Session session) {
        return session.getSystemProperty(SPILL_WINDOW_OPERATOR, Boolean.class);
    }

    public static DataSize getAggregationOperatorUnspillMemoryLimit(Session session) {
        DataSize memoryLimitForMerge = session.getSystemProperty(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((memoryLimitForMerge.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return memoryLimitForMerge;
    }

    public static boolean isOptimizeDistinctAggregationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_DISTINCT_AGGREGATIONS, Boolean.class);
    }

    public static boolean isNewOptimizerEnabled(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER, Boolean.class);
    }

    public static boolean isLegacyTimestamp(Session session) {
        return session.getSystemProperty(LEGACY_TIMESTAMP, Boolean.class);
    }

    public static Duration getOptimizerTimeout(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER_TIMEOUT, Duration.class);
    }

    public static boolean isEnableForcedExchangeBelowGroupId(Session session) {
        return session.getSystemProperty(ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID, Boolean.class);
    }

    public static boolean isExchangeCompressionEnabled(Session session) {
        return session.getSystemProperty(EXCHANGE_COMPRESSION, Boolean.class);
    }

    public static boolean isEnableIntermediateAggregations(Session session) {
        return session.getSystemProperty(ENABLE_INTERMEDIATE_AGGREGATIONS, Boolean.class);
    }

    public static boolean shouldPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isParseDecimalLiteralsAsDouble(Session session) {
        return session.getSystemProperty(PARSE_DECIMAL_LITERALS_AS_DOUBLE, Boolean.class);
    }

    public static boolean isForceSingleNodeOutput(Session session) {
        return session.getSystemProperty(FORCE_SINGLE_NODE_OUTPUT, Boolean.class);
    }

    public static DataSize getFilterAndProjectMinOutputPageSize(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, DataSize.class);
    }

    public static int getFilterAndProjectMinOutputPageRowCount(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, Integer.class);
    }

    public static boolean useMarkDistinct(Session session) {
        return session.getSystemProperty(USE_MARK_DISTINCT, Boolean.class);
    }

    public static boolean preferPartialAggregation(Session session) {
        return session.getSystemProperty(PREFER_PARTIAL_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeTopNRowNumber(Session session) {
        return session.getSystemProperty(OPTIMIZE_TOP_N_ROW_NUMBER, Boolean.class);
    }

    public static boolean isDistributedSortEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_SORT, Boolean.class);
    }

    public static int getMaxGroupingSets(Session session) {
        return session.getSystemProperty(MAX_GROUPING_SETS, Integer.class);
    }

    public static OptionalInt getMaxDriversPerTask(Session session) {
        Integer value = session.getSystemProperty(MAX_DRIVERS_PER_TASK, Integer.class);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    private static int validateValueIsPowerOfTwo(Object value, String property) {
        int intValue = ((Number)Objects.requireNonNull(value, "value is null")).intValue();
        if (Integer.bitCount(intValue) != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be a power of 2: %s", property, intValue));
        }
        return intValue;
    }

    private static Integer validateNullablePositiveIntegerValue(Object value, String property) {
        return SystemSessionProperties.validateIntegerValue(value, property, 1, true);
    }

    private static Integer validateIntegerValue(Object value, String property, int lowerBoundIncluded, boolean allowNull) {
        if (value == null && !allowNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be non-null", property));
        }
        if (value == null) {
            return null;
        }
        int intValue = ((Number)value).intValue();
        if (intValue < lowerBoundIncluded) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be equal or greater than %s", property, lowerBoundIncluded));
        }
        return intValue;
    }

    public static boolean isStatisticsCpuTimerEnabled(Session session) {
        return session.getSystemProperty(STATISTICS_CPU_TIMER_ENABLED, Boolean.class);
    }

    public static boolean isEnableStatsCalculator(Session session) {
        return session.getSystemProperty(ENABLE_STATS_CALCULATOR, Boolean.class);
    }

    public static boolean isIgnoreStatsCalculatorFailures(Session session) {
        return session.getSystemProperty(IGNORE_STATS_CALCULATOR_FAILURES, Boolean.class);
    }

    public static boolean isDefaultFilterFactorEnabled(Session session) {
        return session.getSystemProperty(DEFAULT_FILTER_FACTOR_ENABLED, Boolean.class);
    }

    public static boolean isWorkProcessorPipelines(Session session) {
        return session.getSystemProperty(WORK_PROCESSOR_PIPELINES, Boolean.class);
    }
}

