/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.ConnectorAwareNodeManager;
import io.prestosql.connector.ConnectorContextInstance;
import io.prestosql.connector.informationschema.InformationSchemaConnector;
import io.prestosql.connector.system.DelegatingSystemTablesProvider;
import io.prestosql.connector.system.MetadataBasedSystemTablesProvider;
import io.prestosql.connector.system.StaticSystemTablesProvider;
import io.prestosql.connector.system.SystemConnector;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.index.IndexManager;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.HandleResolver;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControlManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorIndexProvider;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.split.PageSinkManager;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.RecordPageSourceProvider;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class ConnectorManager {
    private static final Logger log = Logger.get(ConnectorManager.class);
    private final MetadataManager metadataManager;
    private final CatalogManager catalogManager;
    private final AccessControlManager accessControlManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final InternalNodeManager nodeManager;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final TransactionManager transactionManager;
    @GuardedBy(value="this")
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    @GuardedBy(value="this")
    private final ConcurrentMap<CatalogName, MaterializedConnector> connectors = new ConcurrentHashMap<CatalogName, MaterializedConnector>();
    private final AtomicBoolean stopped = new AtomicBoolean();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, CatalogManager catalogManager, AccessControlManager accessControlManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, InternalNodeManager nodeManager, NodeInfo nodeInfo, TypeManager typeManager, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, TransactionManager transactionManager) {
        this.metadataManager = metadataManager;
        this.catalogManager = catalogManager;
        this.accessControlManager = accessControlManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.nodePartitioningManager = nodePartitioningManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.typeManager = typeManager;
        this.pageSorter = pageSorter;
        this.pageIndexerFactory = pageIndexerFactory;
        this.nodeInfo = nodeInfo;
        this.transactionManager = transactionManager;
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.connectors.entrySet()) {
            Connector connector = ((MaterializedConnector)entry.getValue()).getConnector();
            try {
                ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());
                Throwable throwable = null;
                try {
                    connector.shutdown();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{entry.getKey()});
            }
        }
    }

    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object)connectorFactory.getName());
        this.handleResolver.addConnectorName(connectorFactory.getName(), connectorFactory.getHandleResolver());
    }

    public synchronized CatalogName createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Objects.requireNonNull(connectorName, "connectorName is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector [%s].  Available factories: %s", (Object)connectorName, this.connectorFactories.keySet());
        return this.createConnection(catalogName, connectorFactory, properties);
    }

    private synchronized CatalogName createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Preconditions.checkArgument((!this.catalogManager.getCatalog(catalogName).isPresent() ? 1 : 0) != 0, (String)"A catalog already exists for %s", (Object)catalogName);
        CatalogName catalog = new CatalogName(catalogName);
        Preconditions.checkState((!this.connectors.containsKey(catalog) ? 1 : 0) != 0, (String)"A catalog %s already exists", (Object)catalog);
        this.addCatalogConnector(catalog, connectorFactory, properties);
        return catalog;
    }

    private synchronized void addCatalogConnector(CatalogName catalogName, ConnectorFactory factory, Map<String, String> properties) {
        MaterializedConnector connector = new MaterializedConnector(catalogName, this.createConnector(catalogName, factory, properties));
        MaterializedConnector informationSchemaConnector = new MaterializedConnector(CatalogName.createInformationSchemaCatalogName(catalogName), new InformationSchemaConnector(catalogName.getCatalogName(), this.nodeManager, this.metadataManager, this.accessControlManager));
        CatalogName systemId = CatalogName.createSystemTablesCatalogName(catalogName);
        SystemTablesProvider systemTablesProvider = this.nodeManager.getCurrentNode().isCoordinator() ? new DelegatingSystemTablesProvider(new StaticSystemTablesProvider(connector.getSystemTables()), new MetadataBasedSystemTablesProvider(this.metadataManager, catalogName.getCatalogName())) : new StaticSystemTablesProvider(connector.getSystemTables());
        MaterializedConnector systemConnector = new MaterializedConnector(systemId, new SystemConnector(this.nodeManager, systemTablesProvider, transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, catalogName)));
        Catalog catalog = new Catalog(catalogName.getCatalogName(), connector.getCatalogName(), connector.getConnector(), informationSchemaConnector.getCatalogName(), informationSchemaConnector.getConnector(), systemConnector.getCatalogName(), systemConnector.getConnector());
        try {
            this.addConnectorInternal(connector);
            this.addConnectorInternal(informationSchemaConnector);
            this.addConnectorInternal(systemConnector);
            this.catalogManager.registerCatalog(catalog);
        }
        catch (Throwable e) {
            this.catalogManager.removeCatalog(catalog.getCatalogName());
            this.removeConnectorInternal(systemConnector.getCatalogName());
            this.removeConnectorInternal(informationSchemaConnector.getCatalogName());
            this.removeConnectorInternal(connector.getCatalogName());
            throw e;
        }
    }

    private synchronized void addConnectorInternal(MaterializedConnector connector) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        CatalogName catalogName = connector.getCatalogName();
        Preconditions.checkState((!this.connectors.containsKey(catalogName) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object)catalogName);
        this.connectors.put(catalogName, connector);
        this.splitManager.addConnectorSplitManager(catalogName, connector.getSplitManager());
        this.pageSourceManager.addConnectorPageSourceProvider(catalogName, connector.getPageSourceProvider());
        connector.getPageSinkProvider().ifPresent(pageSinkProvider -> this.pageSinkManager.addConnectorPageSinkProvider(catalogName, (ConnectorPageSinkProvider)pageSinkProvider));
        connector.getIndexProvider().ifPresent(indexProvider -> this.indexManager.addIndexProvider(catalogName, (ConnectorIndexProvider)indexProvider));
        connector.getPartitioningProvider().ifPresent(partitioningProvider -> this.nodePartitioningManager.addPartitioningProvider(catalogName, (ConnectorNodePartitioningProvider)partitioningProvider));
        this.metadataManager.getProcedureRegistry().addProcedures(catalogName, connector.getProcedures());
        connector.getAccessControl().ifPresent(accessControl -> this.accessControlManager.addCatalogAccessControl(catalogName, (ConnectorAccessControl)accessControl));
        this.metadataManager.getTablePropertyManager().addProperties(catalogName, connector.getTableProperties());
        this.metadataManager.getColumnPropertyManager().addProperties(catalogName, connector.getColumnProperties());
        this.metadataManager.getSchemaPropertyManager().addProperties(catalogName, connector.getSchemaProperties());
        this.metadataManager.getAnalyzePropertyManager().addProperties(catalogName, connector.getAnalyzeProperties());
        this.metadataManager.getSessionPropertyManager().addConnectorSessionProperties(catalogName, connector.getSessionProperties());
    }

    public synchronized void dropConnection(String catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogManager.removeCatalog(catalogName).ifPresent(catalog -> {
            this.removeConnectorInternal((CatalogName)catalog);
            this.removeConnectorInternal(CatalogName.createInformationSchemaCatalogName(catalog));
            this.removeConnectorInternal(CatalogName.createSystemTablesCatalogName(catalog));
        });
    }

    private synchronized void removeConnectorInternal(CatalogName catalogName) {
        this.splitManager.removeConnectorSplitManager(catalogName);
        this.pageSourceManager.removeConnectorPageSourceProvider(catalogName);
        this.pageSinkManager.removeConnectorPageSinkProvider(catalogName);
        this.indexManager.removeIndexProvider(catalogName);
        this.nodePartitioningManager.removePartitioningProvider(catalogName);
        this.metadataManager.getProcedureRegistry().removeProcedures(catalogName);
        this.accessControlManager.removeCatalogAccessControl(catalogName);
        this.metadataManager.getTablePropertyManager().removeProperties(catalogName);
        this.metadataManager.getColumnPropertyManager().removeProperties(catalogName);
        this.metadataManager.getSchemaPropertyManager().removeProperties(catalogName);
        this.metadataManager.getAnalyzePropertyManager().removeProperties(catalogName);
        this.metadataManager.getSessionPropertyManager().removeConnectorSessionProperties(catalogName);
        MaterializedConnector materializedConnector = (MaterializedConnector)this.connectors.remove(catalogName);
        if (materializedConnector != null) {
            Connector connector = materializedConnector.getConnector();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connector.getClass().getClassLoader());){
                connector.shutdown();
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{catalogName});
            }
        }
    }

    private Connector createConnector(CatalogName catalogName, ConnectorFactory factory, Map<String, String> properties) {
        ConnectorContextInstance context = new ConnectorContextInstance(new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), catalogName), this.typeManager, this.pageSorter, this.pageIndexerFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            Connector connector = factory.create(catalogName.getCatalogName(), properties, (ConnectorContext)context);
            return connector;
        }
    }

    private static class MaterializedConnector {
        private final CatalogName catalogName;
        private final Connector connector;
        private final ConnectorSplitManager splitManager;
        private final Set<SystemTable> systemTables;
        private final Set<Procedure> procedures;
        private final ConnectorPageSourceProvider pageSourceProvider;
        private final Optional<ConnectorPageSinkProvider> pageSinkProvider;
        private final Optional<ConnectorIndexProvider> indexProvider;
        private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
        private final Optional<ConnectorAccessControl> accessControl;
        private final List<PropertyMetadata<?>> sessionProperties;
        private final List<PropertyMetadata<?>> tableProperties;
        private final List<PropertyMetadata<?>> schemaProperties;
        private final List<PropertyMetadata<?>> columnProperties;
        private final List<PropertyMetadata<?>> analyzeProperties;

        public MaterializedConnector(CatalogName catalogName, Connector connector) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.connector = Objects.requireNonNull(connector, "connector is null");
            this.splitManager = connector.getSplitManager();
            Preconditions.checkState((this.splitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object)catalogName);
            Set systemTables = connector.getSystemTables();
            Objects.requireNonNull(systemTables, "Connector %s returned a null system tables set");
            this.systemTables = ImmutableSet.copyOf((Collection)systemTables);
            Set procedures = connector.getProcedures();
            Objects.requireNonNull(procedures, "Connector %s returned a null procedures set");
            this.procedures = ImmutableSet.copyOf((Collection)procedures);
            ConnectorPageSourceProvider connectorPageSourceProvider = null;
            try {
                connectorPageSourceProvider = connector.getPageSourceProvider();
                Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector %s returned a null page source provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (connectorPageSourceProvider == null) {
                ConnectorRecordSetProvider connectorRecordSetProvider = null;
                try {
                    connectorRecordSetProvider = connector.getRecordSetProvider();
                    Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector %s returned a null record set provider", catalogName));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s has neither a PageSource or RecordSet provider", (Object)catalogName);
                connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
            }
            this.pageSourceProvider = connectorPageSourceProvider;
            ConnectorPageSinkProvider connectorPageSinkProvider = null;
            try {
                connectorPageSinkProvider = connector.getPageSinkProvider();
                Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector %s returned a null page sink provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.pageSinkProvider = Optional.ofNullable(connectorPageSinkProvider);
            ConnectorIndexProvider indexProvider = null;
            try {
                indexProvider = connector.getIndexProvider();
                Objects.requireNonNull(indexProvider, String.format("Connector %s returned a null index provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.indexProvider = Optional.ofNullable(indexProvider);
            ConnectorNodePartitioningProvider partitioningProvider = null;
            try {
                partitioningProvider = connector.getNodePartitioningProvider();
                Objects.requireNonNull(partitioningProvider, String.format("Connector %s returned a null partitioning provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.partitioningProvider = Optional.ofNullable(partitioningProvider);
            ConnectorAccessControl accessControl = null;
            try {
                accessControl = connector.getAccessControl();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.accessControl = Optional.ofNullable(accessControl);
            List sessionProperties = connector.getSessionProperties();
            Objects.requireNonNull(sessionProperties, "Connector %s returned a null system properties set");
            this.sessionProperties = ImmutableList.copyOf((Collection)sessionProperties);
            List tableProperties = connector.getTableProperties();
            Objects.requireNonNull(tableProperties, "Connector %s returned a null table properties set");
            this.tableProperties = ImmutableList.copyOf((Collection)tableProperties);
            List schemaProperties = connector.getSchemaProperties();
            Objects.requireNonNull(schemaProperties, "Connector %s returned a null schema properties set");
            this.schemaProperties = ImmutableList.copyOf((Collection)schemaProperties);
            List columnProperties = connector.getColumnProperties();
            Objects.requireNonNull(columnProperties, "Connector %s returned a null column properties set");
            this.columnProperties = ImmutableList.copyOf((Collection)columnProperties);
            List analyzeProperties = connector.getAnalyzeProperties();
            Objects.requireNonNull(analyzeProperties, "Connector %s returned a null analyze properties set");
            this.analyzeProperties = ImmutableList.copyOf((Collection)analyzeProperties);
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public Connector getConnector() {
            return this.connector;
        }

        public ConnectorSplitManager getSplitManager() {
            return this.splitManager;
        }

        public Set<SystemTable> getSystemTables() {
            return this.systemTables;
        }

        public Set<Procedure> getProcedures() {
            return this.procedures;
        }

        public ConnectorPageSourceProvider getPageSourceProvider() {
            return this.pageSourceProvider;
        }

        public Optional<ConnectorPageSinkProvider> getPageSinkProvider() {
            return this.pageSinkProvider;
        }

        public Optional<ConnectorIndexProvider> getIndexProvider() {
            return this.indexProvider;
        }

        public Optional<ConnectorNodePartitioningProvider> getPartitioningProvider() {
            return this.partitioningProvider;
        }

        public Optional<ConnectorAccessControl> getAccessControl() {
            return this.accessControl;
        }

        public List<PropertyMetadata<?>> getSessionProperties() {
            return this.sessionProperties;
        }

        public List<PropertyMetadata<?>> getTableProperties() {
            return this.tableProperties;
        }

        public List<PropertyMetadata<?>> getColumnProperties() {
            return this.columnProperties;
        }

        public List<PropertyMetadata<?>> getSchemaProperties() {
            return this.schemaProperties;
        }

        public List<PropertyMetadata<?>> getAnalyzeProperties() {
            return this.analyzeProperties;
        }
    }
}

