/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.connector.informationschema.InformationSchemaColumnHandle;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InformationSchemaMetadata
implements ConnectorMetadata {
    public static final String INFORMATION_SCHEMA = "information_schema";
    public static final SchemaTableName TABLE_COLUMNS = new SchemaTableName("information_schema", "columns");
    public static final SchemaTableName TABLE_TABLES = new SchemaTableName("information_schema", "tables");
    public static final SchemaTableName TABLE_VIEWS = new SchemaTableName("information_schema", "views");
    public static final SchemaTableName TABLE_SCHEMATA = new SchemaTableName("information_schema", "schemata");
    public static final SchemaTableName TABLE_TABLE_PRIVILEGES = new SchemaTableName("information_schema", "table_privileges");
    public static final SchemaTableName TABLE_ROLES = new SchemaTableName("information_schema", "roles");
    public static final SchemaTableName TABLE_APPLICABLE_ROLES = new SchemaTableName("information_schema", "applicable_roles");
    public static final SchemaTableName TABLE_ENABLED_ROLES = new SchemaTableName("information_schema", "enabled_roles");
    public static final Map<SchemaTableName, ConnectorTableMetadata> TABLES = MetadataUtil.SchemaMetadataBuilder.schemaMetadataBuilder().table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_COLUMNS).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("ordinal_position", (Type)BigintType.BIGINT).column("column_default", (Type)VarcharType.createUnboundedVarcharType()).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).column("extra_info", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("column_comment", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_TABLES).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).hiddenColumn("table_comment", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_VIEWS).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("view_definition", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_SCHEMATA).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_TABLE_PRIVILEGES).column("grantor", (Type)VarcharType.createUnboundedVarcharType()).column("grantor_type", (Type)VarcharType.createUnboundedVarcharType()).column("grantee", (Type)VarcharType.createUnboundedVarcharType()).column("grantee_type", (Type)VarcharType.createUnboundedVarcharType()).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("privilege_type", (Type)VarcharType.createUnboundedVarcharType()).column("is_grantable", (Type)VarcharType.createUnboundedVarcharType()).column("with_hierarchy", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_ROLES).column("role_name", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_APPLICABLE_ROLES).column("grantee", (Type)VarcharType.createUnboundedVarcharType()).column("grantee_type", (Type)VarcharType.createUnboundedVarcharType()).column("role_name", (Type)VarcharType.createUnboundedVarcharType()).column("is_grantable", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_ENABLED_ROLES).column("role_name", (Type)VarcharType.createUnboundedVarcharType()).build()).build();
    private static final InformationSchemaColumnHandle CATALOG_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_catalog");
    private static final InformationSchemaColumnHandle SCHEMA_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_schema");
    private static final InformationSchemaColumnHandle TABLE_NAME_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_name");
    private static final int MAX_PREFIXES_COUNT = 100;
    private final String catalogName;
    private final Metadata metadata;

    public InformationSchemaMetadata(String catalogName, Metadata metadata) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    private InformationSchemaTableHandle checkTableHandle(ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.getCatalogName().equals(this.catalogName), (String)"invalid table handle: expected catalog %s but got %s", (Object)this.catalogName, (Object)handle.getCatalogName());
        Preconditions.checkArgument((boolean)TABLES.containsKey(handle.getSchemaTableName()), (String)"table %s does not exist", (Object)handle.getSchemaTableName());
        return handle;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)INFORMATION_SCHEMA);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession connectorSession, SchemaTableName tableName) {
        if (!TABLES.containsKey(tableName)) {
            return null;
        }
        return new InformationSchemaTableHandle(this.catalogName, tableName.getSchemaName(), tableName.getTableName(), this.defaultPrefixes());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        return TABLES.get(informationSchemaTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (!schemaName.isPresent()) {
            return ImmutableList.copyOf(TABLES.keySet());
        }
        return (List)TABLES.keySet().stream().filter(Predicates.compose(schemaName.get()::equals, SchemaTableName::getSchemaName)).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((InformationSchemaColumnHandle)columnHandle).getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        return tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toMap(Function.identity(), InformationSchemaColumnHandle::new));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, ConnectorTableMetadata> entry : TABLES.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getColumns());
        }
        return builder.build();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        InformationSchemaTableHandle table = (InformationSchemaTableHandle)handle;
        if (!table.getPrefixes().equals(this.defaultPrefixes())) {
            return Optional.empty();
        }
        Set<QualifiedTablePrefix> prefixes = this.getPrefixes(session, table, constraint);
        table = new InformationSchemaTableHandle(table.getCatalogName(), table.getSchemaName(), table.getTableName(), prefixes);
        return Optional.of(new ConstraintApplicationResult((Object)table, constraint.getSummary()));
    }

    private Set<QualifiedTablePrefix> defaultPrefixes() {
        return ImmutableSet.of((Object)new QualifiedTablePrefix(this.catalogName));
    }

    private Set<QualifiedTablePrefix> getPrefixes(ConnectorSession session, InformationSchemaTableHandle table, Constraint constraint) {
        Set<QualifiedTablePrefix> tablePrefixes;
        InformationSchemaTableHandle handle = this.checkTableHandle(table);
        if (constraint.getSummary().isNone()) {
            return ImmutableSet.of();
        }
        Set<QualifiedTablePrefix> prefixes = this.calculatePrefixesWithSchemaName(session, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate());
        if (this.isTablesEnumeratingTable(handle.getSchemaTableName()) && (tablePrefixes = this.calculatePrefixesWithTableName(session, prefixes, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate())).size() <= 100) {
            prefixes = tablePrefixes;
        }
        if (prefixes.size() > 100) {
            prefixes = this.defaultPrefixes();
        }
        return prefixes;
    }

    private boolean isTablesEnumeratingTable(SchemaTableName schemaTableName) {
        return ImmutableSet.of((Object)TABLE_COLUMNS, (Object)TABLE_VIEWS, (Object)TABLE_TABLES, (Object)TABLE_TABLES, (Object)TABLE_TABLE_PRIVILEGES).contains((Object)schemaTableName);
    }

    private Set<QualifiedTablePrefix> calculatePrefixesWithSchemaName(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Optional<Set<String>> schemas = this.filterString(constraint, SCHEMA_COLUMN_HANDLE);
        if (schemas.isPresent()) {
            return (Set)schemas.get().stream().filter(this::isLowerCase).map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema)).collect(ImmutableSet.toImmutableSet());
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        return (Set)this.metadata.listSchemaNames(session, this.catalogName).stream().filter(schema -> !predicate.isPresent() || ((Predicate)predicate.get()).test(this.schemaAsFixedValues((String)schema))).map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<QualifiedTablePrefix> calculatePrefixesWithTableName(ConnectorSession connectorSession, Set<QualifiedTablePrefix> prefixes, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<Set<String>> tables = this.filterString(constraint, TABLE_NAME_COLUMN_HANDLE);
        if (tables.isPresent()) {
            return (Set)prefixes.stream().flatMap(prefix -> ((Set)tables.get()).stream().filter(this::isLowerCase).map(table -> table.toLowerCase(Locale.ENGLISH)).map(table -> new QualifiedObjectName(this.catalogName, prefix.getSchemaName().get(), (String)table))).filter(objectName -> this.metadata.getTableHandle(session, (QualifiedObjectName)objectName).isPresent() || this.metadata.getView(session, (QualifiedObjectName)objectName).isPresent()).map(QualifiedObjectName::asQualifiedTablePrefix).collect(ImmutableSet.toImmutableSet());
        }
        return (Set)prefixes.stream().flatMap(prefix -> Stream.concat(this.metadata.listTables(session, (QualifiedTablePrefix)prefix).stream(), this.metadata.listViews(session, (QualifiedTablePrefix)prefix).stream())).filter(objectName -> !predicate.isPresent() || ((Predicate)predicate.get()).test(this.asFixedValues((QualifiedObjectName)objectName))).map(QualifiedObjectName::asQualifiedTablePrefix).collect(ImmutableSet.toImmutableSet());
    }

    private <T> Optional<Set<String>> filterString(TupleDomain<T> constraint, T column) {
        if (constraint.isNone()) {
            return Optional.of(ImmutableSet.of());
        }
        Domain domain = (Domain)((Map)constraint.getDomains().get()).get(column);
        if (domain == null) {
            return Optional.empty();
        }
        if (domain.isSingleValue()) {
            return Optional.of(ImmutableSet.of((Object)((Slice)domain.getSingleValue()).toStringUtf8()));
        }
        if (domain.getValues() instanceof EquatableValueSet) {
            Collection values = ((EquatableValueSet)domain.getValues()).getValues();
            return Optional.of(values.stream().map(Slice.class::cast).map(Slice::toStringUtf8).collect(ImmutableSet.toImmutableSet()));
        }
        return Optional.empty();
    }

    private Map<ColumnHandle, NullableValue> schemaAsFixedValues(String schema) {
        return ImmutableMap.of((Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)schema)));
    }

    private Map<ColumnHandle, NullableValue> asFixedValues(QualifiedObjectName objectName) {
        return ImmutableMap.of((Object)CATALOG_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getCatalogName())), (Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getSchemaName())), (Object)TABLE_NAME_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getObjectName())));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private boolean isLowerCase(String value) {
        return value.toLowerCase(Locale.ENGLISH).equals(value);
    }
}

