/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.connector.informationschema.InformationSchemaColumnHandle;
import io.prestosql.connector.informationschema.InformationSchemaMetadata;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.InternalTable;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.metadata.ViewDefinition;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InformationSchemaPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Metadata metadata;
    private final AccessControl accessControl;

    public InformationSchemaPageSourceProvider(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        InternalTable table = this.getInternalTable(session, tableHandle);
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (ColumnHandle column : columns) {
            String columnName = ((InformationSchemaColumnHandle)column).getColumnName();
            int columnIndex = table.getColumnIndex(columnName);
            channels.add(columnIndex);
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        for (Page page : table.getPages()) {
            Block[] blocks = new Block[channels.size()];
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = page.getBlock(((Integer)channels.get(index)).intValue());
            }
            pages.add((Object)new Page(page.getPositionCount(), blocks));
        }
        return new FixedPageSource((Iterable)pages.build());
    }

    private InternalTable getInternalTable(ConnectorSession connectorSession, ConnectorTableHandle tablehandle) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)tablehandle;
        Set<QualifiedTablePrefix> prefixes = handle.getPrefixes();
        return this.getInformationSchemaTable(session, handle.getCatalogName(), handle.getSchemaTableName(), prefixes);
    }

    public InternalTable getInformationSchemaTable(Session session, String catalog, SchemaTableName table, Set<QualifiedTablePrefix> prefixes) {
        if (table.equals((Object)InformationSchemaMetadata.TABLE_COLUMNS)) {
            return this.buildColumns(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLES)) {
            return this.buildTables(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_VIEWS)) {
            return this.buildViews(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_SCHEMATA)) {
            return this.buildSchemata(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES)) {
            return this.buildTablePrivileges(session, prefixes);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_ROLES)) {
            return this.buildRoles(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_APPLICABLE_ROLES)) {
            return this.buildApplicableRoles(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_ENABLED_ROLES)) {
            return this.buildEnabledRoles(session, catalog);
        }
        throw new IllegalArgumentException(String.format("table does not exist: %s", table));
    }

    private InternalTable buildColumns(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_COLUMNS));
        for (QualifiedTablePrefix prefix : prefixes) {
            for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : MetadataListing.listTableColumns(session, this.metadata, this.accessControl, prefix).entrySet()) {
                SchemaTableName tableName = entry.getKey();
                int ordinalPosition = 1;
                for (ColumnMetadata column : entry.getValue()) {
                    if (column.isHidden()) continue;
                    table.add(prefix.getCatalogName(), tableName.getSchemaName(), tableName.getTableName(), column.getName(), ordinalPosition, null, "YES", column.getType().getDisplayName(), column.getComment(), column.getExtraInfo(), column.getComment());
                    ++ordinalPosition;
                }
            }
        }
        return table.build();
    }

    private InternalTable buildTables(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLES));
        for (QualifiedTablePrefix prefix : prefixes) {
            Set<SchemaTableName> tables = MetadataListing.listTables(session, this.metadata, this.accessControl, prefix);
            Set<SchemaTableName> views = MetadataListing.listViews(session, this.metadata, this.accessControl, prefix);
            for (SchemaTableName name : Sets.union(tables, views)) {
                String type = views.contains(name) ? "VIEW" : "BASE TABLE";
                table.add(prefix.getCatalogName(), name.getSchemaName(), name.getTableName(), type, null);
            }
        }
        return table.build();
    }

    private InternalTable buildTablePrivileges(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES));
        for (QualifiedTablePrefix prefix : prefixes) {
            ImmutableList grants = ImmutableList.copyOf(MetadataListing.listTablePrivileges(session, this.metadata, this.accessControl, prefix));
            for (GrantInfo grant : grants) {
                table.add(grant.getGrantor().map(PrestoPrincipal::getName).orElse(null), grant.getGrantor().map(principal -> principal.getType().toString()).orElse(null), grant.getGrantee().getName(), grant.getGrantee().getType().toString(), prefix.getCatalogName(), grant.getSchemaTableName().getSchemaName(), grant.getSchemaTableName().getTableName(), grant.getPrivilegeInfo().getPrivilege().name(), grant.getPrivilegeInfo().isGrantOption() ? "YES" : "NO", grant.getWithHierarchy().map(withHierarchy -> withHierarchy != false ? "YES" : "NO").orElse(null));
            }
        }
        return table.build();
    }

    private InternalTable buildViews(Session session, Set<QualifiedTablePrefix> prefixes) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_VIEWS));
        for (QualifiedTablePrefix prefix : prefixes) {
            for (Map.Entry<QualifiedObjectName, ViewDefinition> entry : this.metadata.getViews(session, prefix).entrySet()) {
                table.add(entry.getKey().getCatalogName(), entry.getKey().getSchemaName(), entry.getKey().getObjectName(), entry.getValue().getOriginalSql());
            }
        }
        return table.build();
    }

    private InternalTable buildSchemata(Session session, String catalogName) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_SCHEMATA));
        for (String schema : MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalogName)) {
            table.add(catalogName, schema);
        }
        return table.build();
    }

    private InternalTable buildRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_ROLES));
        try {
            this.accessControl.checkCanShowRoles(session.getRequiredTransactionId(), session.getIdentity(), catalog);
        }
        catch (AccessDeniedException exception) {
            return table.build();
        }
        for (String role : this.metadata.listRoles(session, catalog)) {
            table.add(role);
        }
        return table.build();
    }

    private InternalTable buildApplicableRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_APPLICABLE_ROLES));
        for (RoleGrant grant : this.metadata.listApplicableRoles(session, new PrestoPrincipal(PrincipalType.USER, session.getUser()), catalog)) {
            PrestoPrincipal grantee = grant.getGrantee();
            table.add(grantee.getName(), grantee.getType().toString(), grant.getRoleName(), grant.isGrantable() ? "YES" : "NO");
        }
        return table.build();
    }

    private InternalTable buildEnabledRoles(Session session, String catalog) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaPageSourceProvider.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_ENABLED_ROLES));
        for (String role : this.metadata.listEnabledRoles(session, catalog)) {
            table.add(role);
        }
        return table.build();
    }

    private static List<ColumnMetadata> informationSchemaTableColumns(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)InformationSchemaMetadata.TABLES.containsKey(tableName), (String)"table does not exist: %s", (Object)tableName);
        return InformationSchemaMetadata.TABLES.get(tableName).getColumns();
    }
}

