/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class InformationSchemaTableHandle
implements ConnectorTableHandle {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final Set<QualifiedTablePrefix> prefixes;

    @JsonCreator
    public InformationSchemaTableHandle(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="prefixes") Set<QualifiedTablePrefix> prefixes) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.prefixes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(prefixes, "prefixes is null"));
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public Set<QualifiedTablePrefix> getPrefixes() {
        return this.prefixes;
    }

    public String toString() {
        return this.catalogName + ":" + this.schemaName + ":" + this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InformationSchemaTableHandle other = (InformationSchemaTableHandle)obj;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }
}

