/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.system.GlobalSystemTransactionHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.transaction.InternalConnector;
import io.prestosql.transaction.TransactionId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GlobalSystemConnector
implements InternalConnector {
    public static final String NAME = "system";
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;

    public GlobalSystemConnector(Set<SystemTable> systemTables, Set<Procedure> procedures) {
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new GlobalSystemTransactionHandle(transactionId);
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return new ConnectorMetadata(){

            public List<String> listSchemaNames(ConnectorSession session) {
                return ImmutableList.of();
            }

            public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
                return null;
            }

            public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
                throw new UnsupportedOperationException();
            }

            public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
                return ImmutableList.of();
            }

            public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
                throw new UnsupportedOperationException();
            }

            public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
                throw new UnsupportedOperationException();
            }

            public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
                return ImmutableMap.of();
            }

            public boolean usesLegacyTableLayouts() {
                return false;
            }

            public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new ConnectorPageSourceProvider(){

            public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }
}

