/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableSet;
import io.prestosql.FullConnectorSession;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataBasedSystemTablesProvider
implements SystemTablesProvider {
    private final Metadata metadata;
    private final String catalogName;

    public MetadataBasedSystemTablesProvider(Metadata metadata, String catalogName) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    @Override
    public Set<SystemTable> listSystemTables(ConnectorSession session) {
        return ImmutableSet.of();
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Optional<SystemTable> systemTable = this.metadata.getSystemTable(((FullConnectorSession)session).getSession(), new QualifiedObjectName(this.catalogName, tableName.getSchemaName(), tableName.getTableName()));
        if (systemTable.isPresent() && systemTable.get().getDistribution() != SystemTable.Distribution.SINGLE_COORDINATOR) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Distribution for dynamic system table must be " + SystemTable.Distribution.SINGLE_COORDINATOR);
        }
        return systemTable;
    }
}

