/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.prestosql.Session;
import io.prestosql.connector.system.SystemConnectorSessionUtil;
import io.prestosql.connector.system.jdbc.FilterUtil;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TableCommentSystemTable
implements SystemTable {
    private static final Logger LOG = Logger.get(TableCommentSystemTable.class);
    private static final SchemaTableName COMMENT_TABLE_NAME = new SchemaTableName("metadata", "table_comments");
    private static final ConnectorTableMetadata COMMENT_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(COMMENT_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableCommentSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return COMMENT_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        Session session = SystemConnectorSessionUtil.toSession(transactionHandle, connectorSession);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)COMMENT_TABLE);
        for (String catalog : FilterUtil.filter(MetadataListing.listCatalogs(session, this.metadata, this.accessControl).keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            Object names = ImmutableSet.of();
            try {
                names = MetadataListing.listTables(session, this.metadata, this.accessControl, prefix);
            }
            catch (PrestoException e) {
                LOG.debug((Throwable)e, "Failed to get tables for catalog: %s", new Object[]{catalog});
            }
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                SchemaTableName name = (SchemaTableName)iterator.next();
                QualifiedObjectName tableName = new QualifiedObjectName(prefix.getCatalogName(), name.getSchemaName(), name.getTableName());
                Optional comment = Optional.empty();
                try {
                    comment = this.metadata.getTableHandle(session, tableName).map(handle -> this.metadata.getTableMetadata(session, (TableHandle)handle)).map(metadata -> metadata.getMetadata().getComment()).get();
                }
                catch (PrestoException e) {
                    LOG.debug((Throwable)e, "Failed to get metadata for table: %s", new Object[]{name});
                }
                table.addRow(new Object[]{prefix.getCatalogName(), name.getSchemaName(), name.getTableName(), comment.orElse(null)});
            }
        }
        return table.build().cursor();
    }
}

