/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableList;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.transaction.TransactionInfo;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TransactionsSystemTable
implements SystemTable {
    public static final SchemaTableName TRANSACTIONS_TABLE_NAME = new SchemaTableName("runtime", "transactions");
    private final ConnectorTableMetadata transactionsTable;
    private final TransactionManager transactionManager;

    @Inject
    public TransactionsSystemTable(TypeManager typeManager, TransactionManager transactionManager) {
        this.transactionsTable = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TRANSACTIONS_TABLE_NAME).column("transaction_id", (Type)VarcharType.createUnboundedVarcharType()).column("isolation_level", (Type)VarcharType.createUnboundedVarcharType()).column("read_only", (Type)BooleanType.BOOLEAN).column("auto_commit_context", (Type)BooleanType.BOOLEAN).column("create_time", (Type)TimestampType.TIMESTAMP).column("idle_time_secs", (Type)BigintType.BIGINT).column("written_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("catalogs", typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature())))).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.transactionsTable;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.transactionsTable);
        for (TransactionInfo info : this.transactionManager.getAllTransactionInfos()) {
            table.addRow(new Object[]{info.getTransactionId().toString(), info.getIsolationLevel().toString(), info.isReadOnly(), info.isAutoCommitContext(), info.getCreateTime().getMillis(), (long)info.getIdleTime().getValue(TimeUnit.SECONDS), info.getWrittenConnectorId().map(CatalogName::getCatalogName).orElse(null), TransactionsSystemTable.createStringsBlock(info.getCatalogNames())});
        }
        return table.build().cursor();
    }

    private static Block createStringsBlock(List<CatalogName> values) {
        VarcharType varchar = VarcharType.createUnboundedVarcharType();
        BlockBuilder builder = varchar.createBlockBuilder(null, values.size());
        for (CatalogName value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            varchar.writeString(builder, value.getCatalogName());
        }
        return builder.build();
    }
}

