/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system.jdbc;

import io.prestosql.Session;
import io.prestosql.connector.system.SystemConnectorSessionUtil;
import io.prestosql.connector.system.jdbc.FilterUtil;
import io.prestosql.connector.system.jdbc.JdbcTable;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ColumnJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "columns");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)BigintType.BIGINT).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_size", (Type)BigintType.BIGINT).column("buffer_length", (Type)BigintType.BIGINT).column("decimal_digits", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).column("nullable", (Type)BigintType.BIGINT).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("column_def", (Type)VarcharType.createUnboundedVarcharType()).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("char_octet_length", (Type)BigintType.BIGINT).column("ordinal_position", (Type)BigintType.BIGINT).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("scope_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("scope_schema", (Type)VarcharType.createUnboundedVarcharType()).column("scope_table", (Type)VarcharType.createUnboundedVarcharType()).column("source_data_type", (Type)BigintType.BIGINT).column("is_autoincrement", (Type)VarcharType.createUnboundedVarcharType()).column("is_generatedcolumn", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public ColumnJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = SystemConnectorSessionUtil.toSession(transactionHandle, connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(MetadataListing.listCatalogs(session, this.metadata, this.accessControl).keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : MetadataListing.listTableColumns(session, this.metadata, this.accessControl, prefix).entrySet()) {
                ColumnJdbcTable.addColumnRows(table, catalog, entry.getKey(), entry.getValue());
            }
        }
        return table.build().cursor();
    }

    private static void addColumnRows(InMemoryRecordSet.Builder builder, String catalog, SchemaTableName tableName, List<ColumnMetadata> columns) {
        int ordinalPosition = 1;
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            builder.addRow(new Object[]{catalog, tableName.getSchemaName(), tableName.getTableName(), column.getName(), ColumnJdbcTable.jdbcDataType(column.getType()), column.getType().getDisplayName(), ColumnJdbcTable.columnSize(column.getType()), 0, ColumnJdbcTable.decimalDigits(column.getType()), ColumnJdbcTable.numPrecRadix(column.getType()), 2, column.getComment(), null, null, null, ColumnJdbcTable.charOctetLength(column.getType()), ordinalPosition, "", null, null, null, null, null, null});
            ++ordinalPosition;
        }
    }

    static int jdbcDataType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return 16;
        }
        if (type.equals(BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 4;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return -6;
        }
        if (type.equals(RealType.REAL)) {
            return 7;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 8;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (Varchars.isVarcharType((Type)type)) {
            return 12;
        }
        if (Chars.isCharType((Type)type)) {
            return 1;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return -3;
        }
        if (type.equals(TimeType.TIME)) {
            return 92;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 2013;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return 93;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return 2014;
        }
        if (type.equals(DateType.DATE)) {
            return 91;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        return 2000;
    }

    static Integer columnSize(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return 19;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 10;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return 3;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getPrecision();
        }
        if (type.equals(RealType.REAL)) {
            return 24;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 53;
        }
        if (Varchars.isVarcharType((Type)type)) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (Chars.isCharType((Type)type)) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        if (type.equals(TimeType.TIME)) {
            return 8;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 14;
        }
        if (type.equals(DateType.DATE)) {
            return 14;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return 23;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return 29;
        }
        return null;
    }

    private static Integer decimalDigits(Type type) {
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getScale();
        }
        return null;
    }

    private static Integer charOctetLength(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (Chars.isCharType((Type)type)) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }

    static Integer numPrecRadix(Type type) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type instanceof DecimalType) {
            return 10;
        }
        if (type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE)) {
            return 2;
        }
        return null;
    }
}

