/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system.jdbc;

import io.prestosql.connector.system.jdbc.ColumnJdbcTable;
import io.prestosql.connector.system.jdbc.JdbcTable;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;

public class TypesJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "types");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)BigintType.BIGINT).column("precision", (Type)BigintType.BIGINT).column("literal_prefix", (Type)VarcharType.createUnboundedVarcharType()).column("literal_suffix", (Type)VarcharType.createUnboundedVarcharType()).column("create_params", (Type)VarcharType.createUnboundedVarcharType()).column("nullable", (Type)BigintType.BIGINT).column("case_sensitive", (Type)BooleanType.BOOLEAN).column("searchable", (Type)BigintType.BIGINT).column("unsigned_attribute", (Type)BooleanType.BOOLEAN).column("fixed_prec_scale", (Type)BooleanType.BOOLEAN).column("auto_increment", (Type)BooleanType.BOOLEAN).column("local_type_name", (Type)VarcharType.createUnboundedVarcharType()).column("minimum_scale", (Type)BigintType.BIGINT).column("maximum_scale", (Type)BigintType.BIGINT).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).build();
    private final TypeManager typeManager;

    @Inject
    public TypesJdbcTable(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (Type type : this.typeManager.getTypes()) {
            TypesJdbcTable.addTypeRow(table, type);
        }
        TypesJdbcTable.addParametricTypeRows(table, this.typeManager.getParametricTypes());
        return table.build().cursor();
    }

    private static void addTypeRow(InMemoryRecordSet.Builder builder, Type type) {
        builder.addRow(new Object[]{type.getDisplayName(), ColumnJdbcTable.jdbcDataType(type), ColumnJdbcTable.columnSize(type), null, null, null, 1, false, type.isComparable() ? 3 : 0, null, false, null, null, 0, 0, null, null, ColumnJdbcTable.numPrecRadix(type)});
    }

    private static void addParametricTypeRows(InMemoryRecordSet.Builder builder, Collection<ParametricType> types) {
        for (ParametricType type : types) {
            String typeName = type.getName();
            builder.addRow(new Object[]{typeName, typeName.equalsIgnoreCase("array") ? 2003 : 2000, null, null, null, null, 1, false, 0, null, false, null, null, 0, 0, null, null, null});
        }
    }
}

