/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.base.Preconditions;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatisticRange;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.sql.planner.Symbol;
import java.util.stream.Stream;

public class PlanNodeStatsEstimateMath {
    private PlanNodeStatsEstimateMath() {
    }

    public static PlanNodeStatsEstimate subtractSubsetStats(PlanNodeStatsEstimate superset, PlanNodeStatsEstimate subset) {
        double subsetRowCount;
        if (superset.isOutputRowCountUnknown() || subset.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        double supersetRowCount = superset.getOutputRowCount();
        double outputRowCount = Double.max(supersetRowCount - (subsetRowCount = subset.getOutputRowCount()), 0.0);
        if (outputRowCount == 0.0) {
            return PlanNodeStatsEstimateMath.createZeroStats(superset);
        }
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        result.setOutputRowCount(outputRowCount);
        superset.getSymbolsWithKnownStatistics().forEach(symbol -> {
            double subsetNonNullsCount;
            double subsetValuesPerDistinctValue;
            double supersetNonNullsCount;
            double supersetValuesPerDistinctValue;
            SymbolStatsEstimate supersetSymbolStats = superset.getSymbolStatistics((Symbol)symbol);
            SymbolStatsEstimate subsetSymbolStats = subset.getSymbolStatistics((Symbol)symbol);
            SymbolStatsEstimate.Builder newSymbolStats = SymbolStatsEstimate.builder();
            newSymbolStats.setAverageRowSize(supersetSymbolStats.getAverageRowSize());
            double supersetNullsCount = supersetSymbolStats.getNullsFraction() * supersetRowCount;
            double subsetNullsCount = subsetSymbolStats.getNullsFraction() * subsetRowCount;
            double newNullsCount = Double.max(supersetNullsCount - subsetNullsCount, 0.0);
            newSymbolStats.setNullsFraction(Double.min(newNullsCount, outputRowCount) / outputRowCount);
            double supersetDistinctValues = supersetSymbolStats.getDistinctValuesCount();
            double subsetDistinctValues = subsetSymbolStats.getDistinctValuesCount();
            double newDistinctValuesCount = Double.isNaN(supersetDistinctValues) || Double.isNaN(subsetDistinctValues) ? Double.NaN : (supersetDistinctValues == 0.0 ? 0.0 : (subsetDistinctValues == 0.0 ? supersetDistinctValues : ((supersetValuesPerDistinctValue = (supersetNonNullsCount = supersetRowCount - supersetNullsCount) / supersetDistinctValues) <= (subsetValuesPerDistinctValue = (subsetNonNullsCount = subsetRowCount - subsetNullsCount) / subsetDistinctValues) ? Double.max(supersetDistinctValues - subsetDistinctValues, 0.0) : supersetDistinctValues)));
            newSymbolStats.setDistinctValuesCount(newDistinctValuesCount);
            newSymbolStats.setLowValue(supersetSymbolStats.getLowValue());
            newSymbolStats.setHighValue(supersetSymbolStats.getHighValue());
            result.addSymbolStatistics((Symbol)symbol, newSymbolStats.build());
        });
        return result.build();
    }

    public static PlanNodeStatsEstimate capStats(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap) {
        if (stats.isOutputRowCountUnknown() || cap.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        double cappedRowCount = Double.min(stats.getOutputRowCount(), cap.getOutputRowCount());
        result.setOutputRowCount(cappedRowCount);
        stats.getSymbolsWithKnownStatistics().forEach(symbol -> {
            SymbolStatsEstimate symbolStats = stats.getSymbolStatistics((Symbol)symbol);
            SymbolStatsEstimate capSymbolStats = cap.getSymbolStatistics((Symbol)symbol);
            SymbolStatsEstimate.Builder newSymbolStats = SymbolStatsEstimate.builder();
            newSymbolStats.setAverageRowSize(symbolStats.getAverageRowSize());
            newSymbolStats.setDistinctValuesCount(Double.min(symbolStats.getDistinctValuesCount(), capSymbolStats.getDistinctValuesCount()));
            newSymbolStats.setLowValue(Double.max(symbolStats.getLowValue(), capSymbolStats.getLowValue()));
            newSymbolStats.setHighValue(Double.min(symbolStats.getHighValue(), capSymbolStats.getHighValue()));
            double numberOfNulls = stats.getOutputRowCount() * symbolStats.getNullsFraction();
            double capNumberOfNulls = cap.getOutputRowCount() * capSymbolStats.getNullsFraction();
            double cappedNumberOfNulls = Double.min(numberOfNulls, capNumberOfNulls);
            double cappedNullsFraction = cappedRowCount == 0.0 ? 1.0 : cappedNumberOfNulls / cappedRowCount;
            newSymbolStats.setNullsFraction(cappedNullsFraction);
            result.addSymbolStatistics((Symbol)symbol, newSymbolStats.build());
        });
        return result.build();
    }

    private static PlanNodeStatsEstimate createZeroStats(PlanNodeStatsEstimate stats) {
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        result.setOutputRowCount(0.0);
        stats.getSymbolsWithKnownStatistics().forEach(symbol -> result.addSymbolStatistics((Symbol)symbol, SymbolStatsEstimate.zero()));
        return result.build();
    }

    public static PlanNodeStatsEstimate addStatsAndSumDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndSumDistinctValues);
    }

    public static PlanNodeStatsEstimate addStatsAndMaxDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndMaxDistinctValues);
    }

    public static PlanNodeStatsEstimate addStatsAndCollapseDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, StatisticRange::addAndCollapseDistinctValues);
    }

    private static PlanNodeStatsEstimate addStats(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right, RangeAdditionStrategy strategy) {
        if (left.isOutputRowCountUnknown() || right.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        double newRowCount = left.getOutputRowCount() + right.getOutputRowCount();
        Stream.concat(left.getSymbolsWithKnownStatistics().stream(), right.getSymbolsWithKnownStatistics().stream()).distinct().forEach(symbol -> {
            SymbolStatsEstimate symbolStats = SymbolStatsEstimate.zero();
            if (newRowCount > 0.0) {
                symbolStats = PlanNodeStatsEstimateMath.addColumnStats(left.getSymbolStatistics((Symbol)symbol), left.getOutputRowCount(), right.getSymbolStatistics((Symbol)symbol), right.getOutputRowCount(), newRowCount, strategy);
            }
            statsBuilder.addSymbolStatistics((Symbol)symbol, symbolStats);
        });
        return statsBuilder.setOutputRowCount(newRowCount).build();
    }

    private static SymbolStatsEstimate addColumnStats(SymbolStatsEstimate leftStats, double leftRows, SymbolStatsEstimate rightStats, double rightRows, double newRowCount, RangeAdditionStrategy strategy) {
        Preconditions.checkArgument((newRowCount > 0.0 ? 1 : 0) != 0, (Object)"newRowCount must be greater than zero");
        StatisticRange leftRange = StatisticRange.from(leftStats);
        StatisticRange rightRange = StatisticRange.from(rightStats);
        StatisticRange sum = strategy.add(leftRange, rightRange);
        double nullsCountRight = rightStats.getNullsFraction() * rightRows;
        double nullsCountLeft = leftStats.getNullsFraction() * leftRows;
        double totalSizeLeft = (leftRows - nullsCountLeft) * leftStats.getAverageRowSize();
        double totalSizeRight = (rightRows - nullsCountRight) * rightStats.getAverageRowSize();
        double newNullsFraction = (nullsCountLeft + nullsCountRight) / newRowCount;
        double newNonNullsRowCount = newRowCount * (1.0 - newNullsFraction);
        double newAverageRowSize = newNonNullsRowCount == 0.0 ? 0.0 : (totalSizeLeft + totalSizeRight) / newNonNullsRowCount;
        return SymbolStatsEstimate.builder().setStatisticsRange(sum).setAverageRowSize(newAverageRowSize).setNullsFraction(newNullsFraction).build();
    }

    @FunctionalInterface
    private static interface RangeAdditionStrategy {
        public StatisticRange add(StatisticRange var1, StatisticRange var2);
    }
}

