/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.InterpretedFunctionInvoker;
import java.util.Collections;
import java.util.OptionalDouble;

final class StatsUtil {
    private StatsUtil() {
    }

    static OptionalDouble toStatsRepresentation(Metadata metadata, Session session, Type type, Object value) {
        return StatsUtil.toStatsRepresentation(metadata.getFunctionRegistry(), session.toConnectorSession(), type, value);
    }

    static OptionalDouble toStatsRepresentation(FunctionRegistry functionRegistry, ConnectorSession session, Type type, Object value) {
        if (StatsUtil.convertibleToDoubleWithCast(type)) {
            InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(functionRegistry);
            Signature castSignature = functionRegistry.getCoercion(type, (Type)DoubleType.DOUBLE);
            return OptionalDouble.of((Double)functionInvoker.invoke(castSignature, session, Collections.singletonList(value)));
        }
        if (DateType.DATE.equals((Object)type)) {
            return OptionalDouble.of(((Long)value).doubleValue());
        }
        return OptionalDouble.empty();
    }

    private static boolean convertibleToDoubleWithCast(Type type) {
        return type instanceof DecimalType || DoubleType.DOUBLE.equals((Object)type) || RealType.REAL.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || BooleanType.BOOLEAN.equals((Object)type);
    }
}

