/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.eventlistener;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.eventlistener.EventListenerFactory;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import io.prestosql.util.PropertiesUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class EventListenerManager {
    private static final Logger log = Logger.get(EventListenerManager.class);
    private static final File EVENT_LISTENER_CONFIGURATION = new File("etc/event-listener.properties");
    private static final String EVENT_LISTENER_PROPERTY_NAME = "event-listener.name";
    private final Map<String, EventListenerFactory> eventListenerFactories = new ConcurrentHashMap<String, EventListenerFactory>();
    private final AtomicReference<Optional<EventListener>> configuredEventListener = new AtomicReference(Optional.empty());

    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        Objects.requireNonNull(eventListenerFactory, "eventListenerFactory is null");
        if (this.eventListenerFactories.putIfAbsent(eventListenerFactory.getName(), eventListenerFactory) != null) {
            throw new IllegalArgumentException(String.format("Event listener '%s' is already registered", eventListenerFactory.getName()));
        }
    }

    public void loadConfiguredEventListener() throws Exception {
        if (EVENT_LISTENER_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(EVENT_LISTENER_CONFIGURATION));
            String eventListenerName = (String)properties.remove(EVENT_LISTENER_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventListenerName) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object)EVENT_LISTENER_CONFIGURATION.getAbsoluteFile(), (Object)EVENT_LISTENER_PROPERTY_NAME);
            this.setConfiguredEventListener(eventListenerName, properties);
        }
    }

    @VisibleForTesting
    protected void setConfiguredEventListener(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading event listener --");
        EventListenerFactory eventListenerFactory = this.eventListenerFactories.get(name);
        Preconditions.checkState((eventListenerFactory != null ? 1 : 0) != 0, (String)"Event listener %s is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(eventListenerFactory.getClass().getClassLoader());){
            EventListener eventListener = eventListenerFactory.create((Map)ImmutableMap.copyOf(properties));
            this.configuredEventListener.set(Optional.of(eventListener));
        }
        log.info("-- Loaded event listener %s --", new Object[]{name});
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCompleted(queryCompletedEvent);
        }
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCreated(queryCreatedEvent);
        }
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().splitCompleted(splitCompletedEvent);
        }
    }
}

