/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.ParameterRewriter;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.CallArgument;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class CallTask
implements DataDefinitionTask<Call> {
    @Override
    public String getName() {
        return "CALL";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListenableFuture<?> execute(Call call, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        void var18_24;
        if (!transactionManager.isAutoCommit(stateMachine.getSession().getRequiredTransactionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Procedures cannot be called within a transaction (use autocommit mode)");
        }
        Session session = stateMachine.getSession();
        QualifiedObjectName procedureName = MetadataUtil.createQualifiedObjectName(session, (Node)call, call.getName());
        CatalogName catalogName = metadata.getCatalogHandle(stateMachine.getSession(), procedureName.getCatalogName()).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)call, "Catalog %s does not exist", procedureName.getCatalogName()));
        Procedure procedure = metadata.getProcedureRegistry().resolve(catalogName, procedureName.asSchemaTableName());
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            positions.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), i);
        }
        Predicate<CallArgument> hasName = argument -> argument.getName().isPresent();
        boolean anyNamed = call.getArguments().stream().anyMatch(hasName);
        boolean allNamed = call.getArguments().stream().allMatch(hasName);
        if (anyNamed && !allNamed) {
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, "Named and positional arguments cannot be mixed", new Object[0]);
        }
        LinkedHashMap<String, Object> names = new LinkedHashMap<String, Object>();
        for (int i = 0; i < call.getArguments().size(); ++i) {
            CallArgument argument2 = (CallArgument)call.getArguments().get(i);
            if (argument2.getName().isPresent()) {
                String string = (String)argument2.getName().get();
                if (names.put(string, argument2) != null) {
                    throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)argument2, "Duplicate procedure argument: %s", string);
                }
                if (positions.containsKey(string)) continue;
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)argument2, "Unknown argument name: %s", string);
            }
            if (i < procedure.getArguments().size()) {
                names.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), argument2);
                continue;
            }
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, "Too many arguments for procedure", new Object[0]);
        }
        if (names.size() < positions.size()) {
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, "Too few arguments for procedure", new Object[0]);
        }
        Object[] values = new Object[procedure.getArguments().size()];
        for (Map.Entry entry : names.entrySet()) {
            CallArgument callArgument = (CallArgument)entry.getValue();
            int index = (Integer)positions.get(entry.getKey());
            Procedure.Argument argument3 = (Procedure.Argument)procedure.getArguments().get(index);
            Expression expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)callArgument.getValue());
            Type type = metadata.getType(argument3.getType());
            Failures.checkCondition(type != null, (ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_DEFINITION, "Unknown procedure argument type: %s", argument3.getType());
            Object value = ExpressionInterpreter.evaluateConstantExpression(expression, type, metadata, session, parameters);
            values[index] = CallTask.toTypeObjectValue(session, type, value);
        }
        MethodType methodType = procedure.getMethodHandle().type();
        boolean bl = false;
        while (var18_24 < procedure.getArguments().size()) {
            if (values[var18_24] == null && ((Class)methodType.parameterType((int)var18_24)).isPrimitive()) {
                String name = ((Procedure.Argument)procedure.getArguments().get((int)var18_24)).getName();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Procedure argument cannot be null: " + name);
            }
            ++var18_24;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Object> valuesIterator = Arrays.asList(values).iterator();
        for (Class<?> type : methodType.parameterList()) {
            if (ConnectorSession.class.isAssignableFrom(type)) {
                arrayList.add(session.toConnectorSession(catalogName));
                continue;
            }
            arrayList.add(valuesIterator.next());
        }
        try {
            procedure.getMethodHandle().invokeWithArguments(arrayList);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_CALL_FAILED, t);
        }
        return Futures.immediateFuture(null);
    }

    private static Object toTypeObjectValue(Session session, Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        return type.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
    }
}

