/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateSchemaTask
implements DataDefinitionTask<CreateSchema> {
    @Override
    public String getName() {
        return "CREATE SCHEMA";
    }

    @Override
    public String explain(CreateSchema statement, List<Expression> parameters) {
        return "CREATE SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(CreateSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName()));
        accessControl.checkCanCreateSchema(session.getRequiredTransactionId(), session.getIdentity(), schema);
        if (metadata.schemaExists(session, schema)) {
            if (!statement.isNotExists()) {
                throw new SemanticException(SemanticErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Schema '%s' already exists", schema);
            }
            return Futures.immediateFuture(null);
        }
        CatalogName catalogName = metadata.getCatalogHandle(session, schema.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + schema.getCatalogName()));
        Map<String, Object> properties = metadata.getSchemaPropertyManager().getProperties(catalogName, schema.getCatalogName(), NodeUtils.mapFromProperties(statement.getProperties()), session, metadata, parameters);
        metadata.createSchema(session, schema, properties);
        return Futures.immediateFuture(null);
    }
}

