/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorCapabilities;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.ColumnDefinition;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LikeClause;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.TableElement;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.UnknownType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public String explain(CreateTable statement, List<Expression> parameters) {
        return "CREATE TABLE " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        return this.internalExecute(statement, metadata, accessControl, stateMachine.getSession(), parameters);
    }

    @VisibleForTesting
    public ListenableFuture<?> internalExecute(CreateTable statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters) {
        block16: {
            Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
                }
                return Futures.immediateFuture(null);
            }
            CatalogName catalogName = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            Object inheritedProperties = ImmutableMap.of();
            boolean includingProperties = false;
            for (TableElement element : statement.getElements()) {
                if (element instanceof ColumnDefinition) {
                    Type type;
                    ColumnDefinition column2 = (ColumnDefinition)element;
                    String name = column2.getName().getValue().toLowerCase(Locale.ENGLISH);
                    try {
                        type = metadata.getType(TypeSignature.parseTypeSignature((String)column2.getType()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (type.equals((Object)UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (columns.containsKey(name)) {
                        throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)column2, "Column name '%s' specified more than once", column2.getName());
                    }
                    if (!column2.isNullable() && !metadata.getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)column2, "Catalog '%s' does not support non-null column for column name '%s'", catalogName.getCatalogName(), column2.getName());
                    }
                    Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(column2.getProperties());
                    Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(catalogName, tableName.getCatalogName(), sqlProperties, session, metadata, parameters);
                    columns.put(name, new ColumnMetadata(name, type, column2.isNullable(), (String)column2.getComment().orElse(null), null, false, columnProperties));
                    continue;
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    QualifiedObjectName likeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName());
                    if (!metadata.getCatalogHandle(session, likeTableName.getCatalogName()).isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "LIKE table catalog '%s' does not exist", likeTableName.getCatalogName());
                    }
                    if (!tableName.getCatalogName().equals(likeTableName.getCatalogName())) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "LIKE table across catalogs is not supported", new Object[0]);
                    }
                    TableHandle likeTable = metadata.getTableHandle(session, likeTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "LIKE table '%s' does not exist", likeTableName));
                    TableMetadata likeTableMetadata = metadata.getTableMetadata(session, likeTable);
                    Optional propertiesOption = likeClause.getPropertiesOption();
                    if (propertiesOption.isPresent() && ((LikeClause.PropertiesOption)propertiesOption.get()).equals((Object)LikeClause.PropertiesOption.INCLUDING)) {
                        if (includingProperties) {
                            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                        }
                        includingProperties = true;
                        inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                    }
                    likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(column -> {
                        if (columns.containsKey(column.getName().toLowerCase(Locale.ENGLISH))) {
                            throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)element, "Column name '%s' specified more than once", column.getName());
                        }
                        columns.put(column.getName().toLowerCase(Locale.ENGLISH), (ColumnMetadata)column);
                    });
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
            }
            accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), tableName);
            Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
            Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(catalogName, tableName.getCatalogName(), sqlProperties, session, metadata, parameters);
            Map<String, Object> finalProperties = CreateTableTask.combineProperties(sqlProperties.keySet(), properties, (Map<String, Object>)inheritedProperties);
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.copyOf(columns.values()), finalProperties, statement.getComment());
            try {
                metadata.createTable(session, tableName.getCatalogName(), tableMetadata, statement.isNotExists());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block16;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

