/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.json.JsonCodec;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.ViewDefinition;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.SqlFormatterUtil;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final JsonCodec<ViewDefinition> codec;
    private final SqlParser sqlParser;

    @Inject
    public CreateViewTask(JsonCodec<ViewDefinition> codec, SqlParser sqlParser, FeaturesConfig featuresConfig) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public String explain(CreateView statement, List<Expression> parameters) {
        return "CREATE VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        accessControl.checkCanCreateView(session.getRequiredTransactionId(), session.getIdentity(), name);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser, Optional.of(parameters));
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata, accessControl, parameters, stateMachine.getWarningCollector());
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ViewDefinition.ViewColumn(field.getName().get(), field.getType())).collect(ImmutableList.toImmutableList());
        Optional<String> owner = Optional.of(session.getUser());
        if (statement.getSecurity().orElse(null) == CreateView.Security.INVOKER) {
            owner = Optional.empty();
        }
        String data = this.codec.toJson((Object)new ViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, owner, !owner.isPresent()));
        metadata.createView(session, name, data, statement.isReplace());
        return Futures.immediateFuture(null);
    }

    private Analysis analyzeStatement(Statement statement, Session session, Metadata metadata, AccessControl accessControl, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, warningCollector);
        return analyzer.analyze(statement);
    }
}

