/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.ForQueryExecution;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.memory.VersionedMemoryPoolId;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    private final DataDefinitionTask<T> task;
    private final T statement;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final QueryStateMachine stateMachine;
    private final List<Expression> parameters;

    private DataDefinitionExecution(DataDefinitionTask<T> task, T statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.parameters = parameters;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.NANOSECONDS);
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.transitionToRunning()) {
                return;
            }
            ListenableFuture<?> future = this.task.execute(this.statement, this.transactionManager, this.metadata, this.accessControl, this.stateMachine, this.parameters);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    DataDefinitionExecution.this.stateMachine.transitionToFinishing();
                }

                public void onFailure(Throwable throwable) {
                    DataDefinitionExecution.this.fail(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable e) {
            this.fail(e);
            Throwables.throwIfInstanceOf((Throwable)e, Error.class);
        }
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.stateMachine.updateQueryInfo(Optional.empty()));
    }

    @Override
    public Plan getQueryPlan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    /* synthetic */ DataDefinitionExecution(DataDefinitionTask x0, Statement x1, TransactionManager x2, Metadata x3, AccessControl x4, QueryStateMachine x5, List x6, 1 x7) {
        this(x0, x1, x2, x3, x4, x5, x6);
    }

    public static class DataDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DataDefinitionExecution<?>> {
        private final LocationFactory locationFactory;
        private final TransactionManager transactionManager;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final ExecutorService executor;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DataDefinitionExecutionFactory(LocationFactory locationFactory, TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, @ForQueryExecution ExecutorService executor, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        @Override
        public DataDefinitionExecution<?> createQueryExecution(String query, Session session, QueryPreparer.PreparedQuery preparedQuery, ResourceGroupId resourceGroup, WarningCollector warningCollector) {
            return this.createDataDefinitionExecution(query, session, resourceGroup, preparedQuery.getStatement(), preparedQuery.getParameters(), warningCollector);
        }

        private <T extends Statement> DataDefinitionExecution<T> createDataDefinitionExecution(String query, Session session, ResourceGroupId resourceGroup, T statement, List<Expression> parameters, WarningCollector warningCollector) {
            DataDefinitionTask<?> task = this.tasks.get(statement.getClass());
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object)statement.getClass().getSimpleName());
            QueryStateMachine stateMachine = QueryStateMachine.begin(query, session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, task.isTransactionControl(), this.transactionManager, this.accessControl, this.executor, this.metadata, warningCollector);
            stateMachine.setUpdateType(task.getName());
            return new DataDefinitionExecution(task, statement, this.transactionManager, this.metadata, this.accessControl, stateMachine, parameters, null);
        }
    }
}

