/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.DropColumn;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class DropColumnTask
implements DataDefinitionTask<DropColumn> {
    @Override
    public String getName() {
        return "DROP COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(DropColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        TableHandle tableHandle = metadata.getTableHandle(session, tableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName));
        String column = statement.getColumn().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanDropColumn(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        ColumnHandle columnHandle = metadata.getColumnHandles(session, tableHandle).get(column);
        if (columnHandle == null) {
            throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", column);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop hidden column", new Object[0]);
        }
        if (metadata.getTableMetadata(session, tableHandle).getColumns().stream().filter(info -> !info.isHidden()).count() <= 1L) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop the only column in a table", new Object[0]);
        }
        metadata.dropColumn(session, tableHandle, columnHandle);
        return Futures.immediateFuture(null);
    }
}

