/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StateMachine;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.VersionedMemoryPoolId;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.planner.Plan;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class FailedQueryExecution
implements QueryExecution {
    private final QueryInfo queryInfo;
    private final Session session;
    private final Executor executor;

    public FailedQueryExecution(Session session, String query, URI self, Optional<ResourceGroupId> resourceGroup, Executor executor, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.queryInfo = QueryInfo.immediateFailureQueryInfo(session, query, self, resourceGroup, cause);
    }

    @Override
    public QueryId getQueryId() {
        return this.queryInfo.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public QueryState getState() {
        return this.queryInfo.getState();
    }

    @Override
    public Plan getQueryPlan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L);
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.NANOSECONDS);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public DateTime getCreateTime() {
        return this.queryInfo.getQueryStats().getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return Optional.ofNullable(this.queryInfo.getQueryStats().getExecutionStartTime());
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.queryInfo.getQueryStats().getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return Optional.ofNullable(this.queryInfo.getQueryStats().getEndTime());
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(this.getQueryInfo().getFailureInfo()).map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return new BasicQueryInfo(this.getQueryInfo());
    }

    @Override
    public void start() {
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return Futures.immediateFuture((Object)((Object)this.queryInfo.getState()));
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(QueryState.FAILED));
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(this.queryInfo));
    }

    @Override
    public void fail(Throwable cause) {
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void cancelQuery() {
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public void pruneInfo() {
    }
}

