/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GrantRoles;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class GrantRolesTask
implements DataDefinitionTask<GrantRoles> {
    @Override
    public String getName() {
        return "GRANT ROLE";
    }

    @Override
    public ListenableFuture<?> execute(GrantRoles statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        Set roles = (Set)statement.getRoles().stream().map(role -> role.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        Set grantees = (Set)statement.getGrantees().stream().map(MetadataUtil::createPrincipal).collect(ImmutableSet.toImmutableSet());
        boolean withAdminOption = statement.isWithAdminOption();
        Optional<PrestoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        String catalog = MetadataUtil.createCatalogName(session, (Node)statement);
        Set<String> availableRoles = metadata.listRoles(session, catalog);
        LinkedHashSet<String> specifiedRoles = new LinkedHashSet<String>();
        specifiedRoles.addAll(roles);
        grantees.stream().filter(principal -> principal.getType() == PrincipalType.ROLE).map(PrestoPrincipal::getName).forEach(specifiedRoles::add);
        if (grantor.isPresent() && grantor.get().getType() == PrincipalType.ROLE) {
            specifiedRoles.add(grantor.get().getName());
        }
        for (String role2 : specifiedRoles) {
            if (availableRoles.contains(role2)) continue;
            throw new SemanticException(SemanticErrorCode.MISSING_ROLE, (Node)statement, "Role '%s' does not exist", role2);
        }
        accessControl.checkCanGrantRoles(session.getRequiredTransactionId(), session.getIdentity(), roles, grantees, withAdminOption, grantor, catalog);
        metadata.grantRoles(session, roles, grantees, withAdminOption, grantor, catalog);
        return Futures.immediateFuture(null);
    }
}

