/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Column;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Input {
    private final CatalogName catalogName;
    private final String schema;
    private final String table;
    private final List<Column> columns;
    private final Optional<Object> connectorInfo;

    @JsonCreator
    public Input(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="connectorInfo") Optional<Object> connectorInfo, @JsonProperty(value="columns") List<Column> columns) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(connectorInfo, "connectorInfo is null");
        Objects.requireNonNull(columns, "columns is null");
        this.catalogName = catalogName;
        this.schema = schema;
        this.table = table;
        this.connectorInfo = connectorInfo;
        this.columns = ImmutableList.copyOf(columns);
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<Object> getConnectorInfo() {
        return this.connectorInfo;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.catalogName, input.catalogName) && Objects.equals(this.schema, input.schema) && Objects.equals(this.table, input.table) && Objects.equals(this.columns, input.columns) && Objects.equals(this.connectorInfo, input.connectorInfo);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schema, this.table, this.columns, this.connectorInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.catalogName).addValue((Object)this.schema).addValue((Object)this.table).addValue(this.columns).toString();
    }
}

