/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.connector.CatalogName;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Output {
    private final CatalogName catalogName;
    private final String schema;
    private final String table;

    @JsonCreator
    public Output(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equals(this.catalogName, output.catalogName) && Objects.equals(this.schema, output.schema) && Objects.equals(this.table, output.table);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schema, this.table);
    }
}

