/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum QueryState {
    QUEUED(false),
    WAITING_FOR_RESOURCES(false),
    PLANNING(false),
    STARTING(false),
    RUNNING(false),
    FINISHING(false),
    FINISHED(true),
    FAILED(true);

    public static final Set<QueryState> TERMINAL_QUERY_STATES;
    private final boolean doneState;

    private QueryState(boolean doneState) {
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    static {
        TERMINAL_QUERY_STATES = (Set)Stream.of(QueryState.values()).filter(QueryState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

