/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.RenameSchema;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class RenameSchemaTask
implements DataDefinitionTask<RenameSchema> {
    @Override
    public String getName() {
        return "RENAME SCHEMA";
    }

    @Override
    public ListenableFuture<?> execute(RenameSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
        CatalogSchemaName target = new CatalogSchemaName(source.getCatalogName(), statement.getTarget().getValue());
        if (!metadata.schemaExists(session, source)) {
            throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)statement, "Schema '%s' does not exist", source);
        }
        if (metadata.schemaExists(session, target)) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Target schema '%s' already exists", target);
        }
        accessControl.checkCanRenameSchema(session.getRequiredTransactionId(), session.getIdentity(), source, statement.getTarget().getValue());
        metadata.renameSchema(session, source, statement.getTarget().getValue());
        return Futures.immediateFuture(null);
    }
}

