/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.RenameTable;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class RenameTableTask
implements DataDefinitionTask<RenameTable> {
    @Override
    public String getName() {
        return "RENAME TABLE";
    }

    @Override
    public ListenableFuture<?> execute(RenameTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()));
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (!metadata.getCatalogHandle(session, target.getCatalogName()).isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (metadata.getTableHandle(session, target).isPresent()) {
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target table '%s' already exists", target);
        }
        if (!tableName.getCatalogName().equals(target.getCatalogName())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Table rename across catalogs is not supported", new Object[0]);
        }
        accessControl.checkCanRenameTable(session.getRequiredTransactionId(), session.getIdentity(), tableName, target);
        metadata.renameTable(session, tableHandle.get(), target);
        return Futures.immediateFuture(null);
    }
}

