/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.ResetSession;
import io.prestosql.transaction.TransactionManager;
import java.util.List;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public ListenableFuture<?> execute(ResetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        List parts = statement.getName().getParts();
        if (parts.size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        if (parts.size() == 1) {
            metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        } else {
            CatalogName catalogName = metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Catalog %s does not exist", parts.get(0)));
            metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(catalogName, (String)parts.get(1)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        }
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return Futures.immediateFuture(null);
    }
}

