/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.security.Privilege;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Revoke;
import io.prestosql.transaction.TransactionManager;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RevokeTask
implements DataDefinitionTask<Revoke> {
    @Override
    public String getName() {
        return "REVOKE";
    }

    @Override
    public ListenableFuture<?> execute(Revoke statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()));
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        Set<Object> privileges = statement.getPrivileges().isPresent() ? (Set)((List)statement.getPrivileges().get()).stream().map(privilege -> RevokeTask.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        for (Privilege privilege2 : privileges) {
            accessControl.checkCanRevokeTablePrivilege(session.getRequiredTransactionId(), session.getIdentity(), privilege2, tableName, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isGrantOptionFor());
        }
        metadata.revokeTablePrivileges(session, tableName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isGrantOptionFor());
        return Futures.immediateFuture(null);
    }

    private static Privilege parsePrivilege(Revoke statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw new SemanticException(SemanticErrorCode.INVALID_PRIVILEGE, (Node)statement, "Unknown privilege: '%s'", privilegeString);
    }
}

