/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.util.List;

public class RollbackTask
implements DataDefinitionTask<Rollback> {
    @Override
    public String getName() {
        return "ROLLBACK";
    }

    @Override
    public ListenableFuture<?> execute(Rollback statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (!session.getTransactionId().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_IN_TRANSACTION, "No transaction in progress");
        }
        TransactionId transactionId = session.getTransactionId().get();
        stateMachine.clearTransactionId();
        transactionManager.asyncAbort(transactionId);
        return Futures.immediateFuture(null);
    }

    @Override
    public boolean isTransactionControl() {
        return true;
    }
}

