/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.transaction.TransactionManager;
import java.util.List;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public ListenableFuture<?> execute(SetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Object objectValue;
        PropertyMetadata<?> propertyMetadata;
        Session session = stateMachine.getSession();
        QualifiedName propertyName = statement.getName();
        List parts = propertyName.getParts();
        if (parts.size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", propertyName);
        }
        if (parts.size() == 1) {
            accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), (String)parts.get(0));
            propertyMetadata = metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        } else {
            CatalogName catalogName = metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Catalog %s does not exist", parts.get(0)));
            accessControl.checkCanSetCatalogSessionProperty(session.getRequiredTransactionId(), session.getIdentity(), (String)parts.get(0), (String)parts.get(1));
            propertyMetadata = metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(catalogName, (String)parts.get(1)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(statement.getValue(), type, session, metadata, parameters);
        }
        catch (SemanticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", propertyName, statement.getValue(), e.getMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        propertyMetadata.decode(objectValue);
        stateMachine.addSetSessionProperties(propertyName.toString(), value);
        return Futures.immediateFuture(null);
    }
}

