/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import io.prestosql.execution.QueryInfo;
import io.prestosql.spi.StandardErrorCode;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlQueryManagerStats {
    private final AtomicInteger queuedQueries = new AtomicInteger();
    private final AtomicInteger runningQueries = new AtomicInteger();
    private final CounterStat submittedQueries = new CounterStat();
    private final CounterStat startedQueries = new CounterStat();
    private final CounterStat completedQueries = new CounterStat();
    private final CounterStat failedQueries = new CounterStat();
    private final CounterStat abandonedQueries = new CounterStat();
    private final CounterStat canceledQueries = new CounterStat();
    private final CounterStat userErrorFailures = new CounterStat();
    private final CounterStat internalFailures = new CounterStat();
    private final CounterStat externalFailures = new CounterStat();
    private final CounterStat insufficientResourcesFailures = new CounterStat();
    private final CounterStat consumedInputRows = new CounterStat();
    private final CounterStat consumedInputBytes = new CounterStat();
    private final CounterStat consumedCpuTimeSecs = new CounterStat();
    private final TimeStat executionTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat queuedTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final DistributionStat wallInputBytesRate = new DistributionStat();
    private final DistributionStat cpuInputByteRate = new DistributionStat();

    public void queryQueued() {
        this.submittedQueries.update(1L);
        this.queuedQueries.incrementAndGet();
    }

    public void queryStarted() {
        this.startedQueries.update(1L);
        this.runningQueries.incrementAndGet();
        this.queuedQueries.decrementAndGet();
    }

    public void queryStopped() {
        this.runningQueries.decrementAndGet();
    }

    public void queryFinished(QueryInfo info) {
        long executionCpuMillis;
        this.completedQueries.update(1L);
        long rawInputBytes = info.getQueryStats().getRawInputDataSize().toBytes();
        this.consumedCpuTimeSecs.update((long)info.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
        this.consumedInputBytes.update(info.getQueryStats().getRawInputDataSize().toBytes());
        this.consumedInputRows.update(info.getQueryStats().getRawInputPositions());
        this.executionTime.add(info.getQueryStats().getExecutionTime());
        this.queuedTime.add(info.getQueryStats().getQueuedTime());
        long executionWallMillis = info.getQueryStats().getExecutionTime().toMillis();
        if (executionWallMillis > 0L) {
            this.wallInputBytesRate.add(rawInputBytes * 1000L / executionWallMillis);
        }
        if ((executionCpuMillis = info.getQueryStats().getTotalCpuTime().toMillis()) > 0L) {
            this.cpuInputByteRate.add(rawInputBytes * 1000L / executionCpuMillis);
        }
        if (info.getErrorCode() != null) {
            switch (info.getErrorCode().getType()) {
                case USER_ERROR: {
                    this.userErrorFailures.update(1L);
                    break;
                }
                case INTERNAL_ERROR: {
                    this.internalFailures.update(1L);
                    break;
                }
                case INSUFFICIENT_RESOURCES: {
                    this.insufficientResourcesFailures.update(1L);
                    break;
                }
                case EXTERNAL: {
                    this.externalFailures.update(1L);
                }
            }
            if (info.getErrorCode().getCode() == StandardErrorCode.ABANDONED_QUERY.toErrorCode().getCode()) {
                this.abandonedQueries.update(1L);
            } else if (info.getErrorCode().getCode() == StandardErrorCode.USER_CANCELED.toErrorCode().getCode()) {
                this.canceledQueries.update(1L);
            }
            this.failedQueries.update(1L);
        }
    }

    @Managed
    public long getRunningQueries() {
        return this.runningQueries.get();
    }

    @Managed
    public long getQueuedQueries() {
        return this.queuedQueries.get();
    }

    @Managed
    @Nested
    public CounterStat getStartedQueries() {
        return this.startedQueries;
    }

    @Managed
    @Nested
    public CounterStat getSubmittedQueries() {
        return this.submittedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCompletedQueries() {
        return this.completedQueries;
    }

    @Managed
    @Nested
    public CounterStat getFailedQueries() {
        return this.failedQueries;
    }

    @Managed
    @Nested
    public CounterStat getConsumedInputRows() {
        return this.consumedInputRows;
    }

    @Managed
    @Nested
    public CounterStat getConsumedInputBytes() {
        return this.consumedInputBytes;
    }

    @Managed
    @Nested
    public CounterStat getConsumedCpuTimeSecs() {
        return this.consumedCpuTimeSecs;
    }

    @Managed
    @Nested
    public TimeStat getExecutionTime() {
        return this.executionTime;
    }

    @Managed
    @Nested
    public TimeStat getQueuedTime() {
        return this.queuedTime;
    }

    @Managed
    @Nested
    public CounterStat getUserErrorFailures() {
        return this.userErrorFailures;
    }

    @Managed
    @Nested
    public CounterStat getInternalFailures() {
        return this.internalFailures;
    }

    @Managed
    @Nested
    public CounterStat getAbandonedQueries() {
        return this.abandonedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCanceledQueries() {
        return this.canceledQueries;
    }

    @Managed
    @Nested
    public CounterStat getExternalFailures() {
        return this.externalFailures;
    }

    @Managed
    @Nested
    public CounterStat getInsufficientResourcesFailures() {
        return this.insufficientResourcesFailures;
    }

    @Managed(description="Distribution of query input data rates (wall)")
    @Nested
    public DistributionStat getWallInputBytesRate() {
        return this.wallInputBytesRate;
    }

    @Managed(description="Distribution of query input data rates (cpu)")
    @Nested
    public DistributionStat getCpuInputByteRate() {
        return this.cpuInputByteRate;
    }
}

