/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.prestosql.execution.FutureStateChange;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StateMachine<T> {
    private static final Logger log = Logger.get(StateMachine.class);
    private final String name;
    private final Executor executor;
    private final Object lock = new Object();
    private final Set<T> terminalStates;
    @GuardedBy(value="lock")
    private volatile T state;
    @GuardedBy(value="lock")
    private final List<StateChangeListener<T>> stateChangeListeners = new ArrayList<StateChangeListener<T>>();
    private final AtomicReference<FutureStateChange<T>> futureStateChange = new AtomicReference(new FutureStateChange());

    public StateMachine(String name, Executor executor, T initialState) {
        this(name, executor, initialState, (Iterable<T>)ImmutableSet.of());
    }

    public StateMachine(String name, Executor executor, T initialState, Iterable<T> terminalStates) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.state = Objects.requireNonNull(initialState, "initialState is null");
        this.terminalStates = ImmutableSet.copyOf(Objects.requireNonNull(terminalStates, "terminalStates is null"));
    }

    public T get() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(T newState) {
        ImmutableList stateChangeListeners;
        FutureStateChange futureStateChange;
        T oldState;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.state.equals(newState)) {
                return this.state;
            }
            Preconditions.checkState((!this.isTerminalState(this.state) ? 1 : 0) != 0, (String)"%s can not transition from %s to %s", (Object)this.name, this.state, newState);
            oldState = this.state;
            this.state = newState;
            futureStateChange = this.futureStateChange.getAndSet(new FutureStateChange());
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            if (this.isTerminalState(this.state)) {
                this.stateChangeListeners.clear();
            }
        }
        this.fireStateChanged(newState, futureStateChange, (List<StateChangeListener<T>>)stateChangeListeners);
        return oldState;
    }

    public boolean setIf(T newState, Predicate<T> predicate) {
        T currentState;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        do {
            if ((currentState = this.get()).equals(newState)) {
                return false;
            }
            if (predicate.test(currentState)) continue;
            return false;
        } while (!this.compareAndSet(currentState, newState));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(T expectedState, T newState) {
        ImmutableList stateChangeListeners;
        FutureStateChange futureStateChange;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(expectedState, "expectedState is null");
        Objects.requireNonNull(newState, "newState is null");
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.equals(expectedState)) {
                return false;
            }
            if (this.state.equals(newState)) {
                return false;
            }
            Preconditions.checkState((!this.isTerminalState(this.state) ? 1 : 0) != 0, (String)"%s can not transition from %s to %s", (Object)this.name, this.state, newState);
            this.state = newState;
            futureStateChange = this.futureStateChange.getAndSet(new FutureStateChange());
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            if (this.isTerminalState(this.state)) {
                this.stateChangeListeners.clear();
            }
        }
        this.fireStateChanged(newState, futureStateChange, (List<StateChangeListener<T>>)stateChangeListeners);
        return true;
    }

    private void fireStateChanged(T newState, FutureStateChange<T> futureStateChange, List<StateChangeListener<T>> stateChangeListeners) {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not fire state change event while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        this.safeExecute(() -> {
            Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not notify while holding the lock");
            try {
                futureStateChange.complete(newState);
            }
            catch (Throwable e) {
                log.error(e, "Error setting future state for %s", new Object[]{this.name});
            }
            for (StateChangeListener stateChangeListener : stateChangeListeners) {
                this.fireStateChangedListener(newState, stateChangeListener);
            }
        });
    }

    private void fireStateChangedListener(T newState, StateChangeListener<T> stateChangeListener) {
        try {
            stateChangeListener.stateChanged(newState);
        }
        catch (Throwable e) {
            log.error(e, "Error notifying state change listener for %s", new Object[]{this.name});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> getStateChange(T currentState) {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not wait for state change while holding the lock");
        Objects.requireNonNull(currentState, "currentState is null");
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.equals(currentState) || this.isTerminalState(this.state)) {
                return Futures.immediateFuture(this.state);
            }
            return this.futureStateChange.get().createNewListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener<T> stateChangeListener) {
        Object currentState;
        Objects.requireNonNull(stateChangeListener, "stateChangeListener is null");
        Object object = this.lock;
        synchronized (object) {
            currentState = this.state;
            boolean inTerminalState = this.isTerminalState(currentState);
            if (!inTerminalState) {
                this.stateChangeListeners.add(stateChangeListener);
            }
        }
        this.safeExecute(() -> stateChangeListener.stateChanged(currentState));
    }

    @VisibleForTesting
    boolean isTerminalState(T state) {
        return this.terminalStates.contains(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<StateChangeListener<T>> getStateChangeListeners() {
        Object object = this.lock;
        synchronized (object) {
            return ImmutableList.copyOf(this.stateChangeListeners);
        }
    }

    public String toString() {
        return this.get().toString();
    }

    private void safeExecute(Runnable command) {
        try {
            this.executor.execute(command);
        }
        catch (RejectedExecutionException e) {
            if (this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    public static interface StateChangeListener<T> {
        public void stateChanged(T var1);
    }
}

