/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Use;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class UseTask
implements DataDefinitionTask<Use> {
    @Override
    public String getName() {
        return "USE";
    }

    @Override
    public ListenableFuture<?> execute(Use statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (!statement.getCatalog().isPresent() && !session.getCatalog().isPresent()) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)statement, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
        if (statement.getCatalog().isPresent()) {
            String catalog = ((Identifier)statement.getCatalog().get()).getValue().toLowerCase(Locale.ENGLISH);
            if (!metadata.getCatalogHandle(session, catalog).isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalog);
            }
            stateMachine.setSetCatalog(catalog);
        }
        stateMachine.setSetSchema(statement.getSchema().getValue().toLowerCase(Locale.ENGLISH));
        return Futures.immediateFuture(null);
    }
}

