/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.util.Objects;
import java.util.Optional;

public class PagesSerdeFactory {
    private final BlockEncodingSerde blockEncodingSerde;
    private final boolean compressionEnabled;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, boolean compressionEnabled) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionEnabled = compressionEnabled;
    }

    public PagesSerde createPagesSerde() {
        if (this.compressionEnabled) {
            return new PagesSerde(this.blockEncodingSerde, Optional.of(new Lz4Compressor()), Optional.of(new Lz4Decompressor()));
        }
        return new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty());
    }
}

