/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import com.google.common.collect.AbstractIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.execution.buffer.PageCompression;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class PagesSerdeUtil {
    private PagesSerdeUtil() {
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    public static void writeSerializedPage(SliceOutput output, SerializedPage page) {
        output.writeInt(page.getPositionCount());
        output.writeByte((int)page.getCompression().getMarker());
        output.writeInt(page.getUncompressedSizeInBytes());
        output.writeInt(page.getSizeInBytes());
        output.writeBytes(page.getSlice());
    }

    private static SerializedPage readSerializedPage(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        byte codecMarker = sliceInput.readByte();
        int uncompressedSizeInBytes = sliceInput.readInt();
        int sizeInBytes = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(Math.toIntExact(sizeInBytes));
        return new SerializedPage(slice, PageCompression.lookupCodecFromMarker(codecMarker), positionCount, uncompressedSizeInBytes);
    }

    public static long writeSerializedPages(SliceOutput sliceOutput, Iterable<SerializedPage> pages) {
        Iterator<SerializedPage> pageIterator = pages.iterator();
        long size = 0L;
        while (pageIterator.hasNext()) {
            SerializedPage page = pageIterator.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, page);
            size += (long)page.getSizeInBytes();
        }
        return size;
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        while (pages.hasNext()) {
            Page page = pages.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, serde.serialize(page));
            size += page.getSizeInBytes();
        }
        return size;
    }

    public static Iterator<Page> readPages(PagesSerde serde, SliceInput sliceInput) {
        return new PageReader(serde, sliceInput);
    }

    public static Iterator<SerializedPage> readSerializedPages(SliceInput sliceInput) {
        return new SerializedPageReader(sliceInput);
    }

    private static class SerializedPageReader
    extends AbstractIterator<SerializedPage> {
        private final SliceInput input;

        SerializedPageReader(SliceInput input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        protected SerializedPage computeNext() {
            if (!this.input.isReadable()) {
                return (SerializedPage)this.endOfData();
            }
            return PagesSerdeUtil.readSerializedPage(this.input);
        }
    }

    private static class PageReader
    extends AbstractIterator<Page> {
        private final PagesSerde serde;
        private final SliceInput input;

        PageReader(PagesSerde serde, SliceInput input) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
        }

        protected Page computeNext() {
            if (!this.input.isReadable()) {
                return (Page)this.endOfData();
            }
            return this.serde.deserialize(PagesSerdeUtil.readSerializedPage(this.input));
        }
    }
}

