/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.execution.buffer.PageCompression;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SerializedPage {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPage.class).instanceSize();
    private static final int PAGE_COMPRESSION_SIZE = ClassLayout.parseClass(PageCompression.class).instanceSize();
    private final Slice slice;
    private final PageCompression compression;
    private final int positionCount;
    private final int uncompressedSizeInBytes;

    public SerializedPage(Slice slice, PageCompression compression, int positionCount, int uncompressedSizeInBytes) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.positionCount = positionCount;
        Preconditions.checkArgument((uncompressedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"uncompressedSizeInBytes is negative");
        Preconditions.checkArgument((compression == PageCompression.UNCOMPRESSED || uncompressedSizeInBytes > slice.length() ? 1 : 0) != 0, (Object)"compressed size must be smaller than uncompressed size when compressed");
        Preconditions.checkArgument((compression == PageCompression.COMPRESSED || uncompressedSizeInBytes == slice.length() ? 1 : 0) != 0, (Object)"uncompressed size must be equal to slice length when uncompressed");
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
    }

    public int getSizeInBytes() {
        return this.slice.length();
    }

    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize() + (long)PAGE_COMPRESSION_SIZE;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public PageCompression getCompression() {
        return this.compression;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("compression", (Object)this.compression).add("sizeInBytes", this.slice.length()).add("uncompressedSizeInBytes", this.uncompressedSizeInBytes).toString();
    }
}

